%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name: klibc
Version: 2.0.13
Release: alt1
Summary: A minimal libc subset for use with initramfs
License: BSD-3-Clause and BSD-4-Clause-UC and GPL-2.0-only and MIT-0
Group: System/Libraries
Url: https://git.kernel.org/pub/scm/libs/klibc/klibc.git

Source0: %name-%version.tar

# due to %%base_arch
BuildRequires(pre): rpm-build-kernel

# Some architectures do not match arch naming in kernel.
%ifarch riscv64
%global base_arch riscv64
%endif
%ifarch ppc64le
%global base_arch ppc64
%endif

%define klibcdir  %_libdir/%name
%define libdocdir %_docdir/%name-%version-%release
%define bindocdir %_docdir/%name-utils-%version-%release

# Use special scripts to find dependencies on klibc-*.so (default RPM scripts
# do not pick up these dependencies).
%global __find_provides %_builddir/%name-%version/.gear/%name-find-provides %__find_provides
%global __find_requires %_builddir/%name-%version/.gear/%name-find-requires %__find_requires

%description
klibc is intended to be a minimalistic libc subset for use with initramfs.
It is deliberately written for small size, minimal entanglement, and
portability, not speed.

%package -n libklibc
Summary: Shared library for klibc
Group: System/Libraries
Obsoletes: klibc < 2.0.13

%description -n libklibc
%summary.

%package devel
Summary: Libraries and tools needed to compile applications against klibc
Group: Development/C
Provides: libklibc-devel = %EVR
Provides: libklibc-devel-static = %EVR
Provides: klcc = %EVR
Requires: libklibc = %EVR
AutoReq: nocpp

%description devel
This package contains the link libraries, header files, and gcc wrapper
scripts needed to compile applications against klibc.

%package utils
Summary: Small utilities built with klibc
Group: System/Kernel and hardware

%description utils
This package contains a collection of programs that are linked against
klibc. These duplicate some of the functionality of a regular Linux
toolset, but are typically much smaller than their full-function
counterparts. They are intended for inclusion in initramfs images
and embedded systems.

%package checkinstall
Summary: CI test package for klibc-devel
Group: Development/Other
BuildArch: noarch
Requires(pre): klibc-devel = %EVR
Requires(pre): gcc

%description checkinstall
%summary.

%prep
%setup
# Install fixed scsi headers
install -d -m 0755 usr/include/scsi
for f in %_includedir/scsi/*; do
	sed '/^#[[:blank:]]*include/s|features.h|sys/stat.h|' "$f" > usr/include/scsi/$(basename "$f")
done

cat > defconfig <<__EOF__
CONFIG_KLIBC=y
# CONFIG_KLIBC_ERRLIST is not set
# CONFIG_KLIBC_ZLIB is not set
# CONFIG_KLIB_ZIP is not set
# CONFIG_KINIT_LOAD_INITRD is not set
# i386 option
CONFIG_REGPARM=y
# ARM options
CONFIG_AEABI=y
# CONFIG_KLIBC_THUMB is not set
CONFIG_DEBUG_INFO=y
__EOF__

UAPIHDRS=$(readlink -ev %_includedir/linux/../..)
# Set global build options.
cat <<-EOF > KLIBC_MAKEFLAGS
	KLIBCARCH=%base_arch
	KLIBCKERNELSRC=$UAPIHDRS
%ifarch armh
	CPU_ARCH=armv7-a+fp
	CPU_TUNE=cortex-a8
%endif
	bindir=%_bindir
	mandir=%_mandir
	prefix=%prefix
	INSTALLDIR=%klibcdir
	INSTALLROOT=%buildroot
	SHLIBDIR=/%_lib
	V=1
EOF
%define KLIBC_MAKEFLAGS $(cat KLIBC_MAKEFLAGS)

%build
%define optflags_debug %nil
%make_build %KLIBC_MAKEFLAGS

%install
%make_install %KLIBC_MAKEFLAGS install
rm -f %buildroot%klibcdir/include/Kbuild

install -p -m 0755 .gear/%name-find-requires %buildroot%klibcdir/

# Install the docs
install -d -m 0755 %buildroot{%bindocdir,%libdocdir}
install -p -m 0644 README usr/%name/{,arch/}README.%{name}* %buildroot%libdocdir/
for f in usr/{gzip/{COPYING,README},kinit{,/ipconfig}/README*,dash/README*}; do
	s=$(basename $(dirname $f))
	install -p -m 0644 $f %buildroot%bindocdir/$(basename -s.$s $f).$s
done

# klibc does not use the dynamic symbol table for dynamic linking so
# klibc-*.so is just interpreter, but GCC needs normal library with symtab.
%brp_strip_debug %klibcdir/lib/libc.so

# Unused duplicate of /lib/klibc-SOHASH.so
rm %buildroot%klibcdir/lib/klibc-*.so

mkdir tests
cp -a usr/klibc/tests/*.c -t tests

%check
# Compile tests.
%make_build %KLIBC_MAKEFLAGS test
ls -l usr/klibc/tests/hello*
usr/klibc/tests/hello
! ldd usr/klibc/tests/hello
# 'shared' does not have NEEDED libs but it have interpreter.
ldd usr/klibc/tests/hello.shared ||:
readelf -l usr/klibc/tests/hello.shared | grep 'interpreter:.*klibc-.*.so'

%pre checkinstall
set -efuxo pipefail
cd /tmp
klcc %_docdir/klibc-devel-%version/tests/hello.c -static
./a.out
klcc %_docdir/klibc-devel-%version/tests/hello.c -shared
./a.out
rm a.out

%files -n libklibc
/%_lib/%name-*.so

%files devel
%klibcdir
%exclude %klibcdir/bin
%klibcdir/%name-find-requires
%_bindir/klcc
%_man1dir/*
%doc %libdocdir
%doc tests

%files utils
%dir %klibcdir
%klibcdir/bin
%doc %bindocdir

%files checkinstall

%changelog
