%define ver_major 43
%define xdg_name org.gnome.KrbAuthDialog
%define gtk_api_ver 3.0

%def_with pkcs11

Name: krb5-auth-dialog
Version: %ver_major.0
Release: alt1

Summary: Kerberos 5 authentication dialog
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://redhat.com

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.58
%define gtk_ver 3.14
%define gcr_ver 3.5.5

%{?_with_pkcs11:Requires: libopensc}

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson flex
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(gcr-3) >= %gcr_ver
BuildRequires: libkrb5-devel libpam-devel
BuildRequires: yelp-tools /usr/bin/appstream-util
%{?_with_pkcs11:BuildRequires: libopensc}

%description
krb5-auth-dialog is a simple dialog that monitors kerberos tickets, and
pops up a dialog when they are about to expire.

%prep
%setup

%build
%meson \
    %{?_with_pkcs11:-Dpkcs11='%_libdir/pkcs11/opensc-pkcs11.so'}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/libka-plugin-afs.so
%_libdir/%name/plugins/libka-plugin-dummy.so
%_libdir/%name/plugins/libka-plugin-gnomelock.so
%_libdir/%name/plugins/libka-plugin-pam.so
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/*/*.*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%name.metainfo.xml
%_sysconfdir/xdg/autostart/%name.desktop
%_man1dir/*
%doc AUTHORS NEWS README*


%changelog
