
%global import_path github.com/kubernetes/kubernetes

%global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1

%define prog_name            kubernetes
%define kubernetes_major     1
%define kubernetes_minor     31
%define kubernetes_patch     14

Name: %prog_name%kubernetes_major.%kubernetes_minor
Version: %kubernetes_major.%kubernetes_minor.%kubernetes_patch
Release: alt1
Summary: Container cluster management

Group: System/Configuration/Other
License: Apache-2.0
Url: https://kubernetes.io
Vcs: https://github.com/kubernetes/kubernetes
Source: %name-%version.tar


Source2: genmanpages.sh
Source3: kubernetes-accounting.conf
Source4: 10-kubeadm.conf

#systemd services
Source10: kube-apiserver.service
Source11: kube-controller-manager.service
Source12: kubelet.service
Source13: kube-proxy.service
Source14: kube-scheduler.service
#config files
Source20: apiserver
Source21: config
Source22: controller-manager
Source23: kubelet
Source24: proxy
Source25: scheduler
Source26: kubernetes.tmpfiles
Source27: crio.conf
Source28: 99-kubernetes-cri.conf

Patch1: runc-alt-loongarch64-support.patch
Patch2: kubernets-alt-loongarch64-support.patch
Patch3: ebpf-alt-loongarch64-support.patch

Provides: %prog_name = %EVR
Conflicts: %prog_name < %EVR
Conflicts: %prog_name > %EVR

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires(pre): golang >= 1.22
BuildRequires: /proc
BuildRequires: rpm-build-golang
BuildRequires: rsync
BuildRequires: go-md2man go-bindata

%description
Kubernetes is an open source system for managing containerized applications
across multiple hosts; providing basic mechanisms
for deployment, maintenance, and scaling of applications.

%package common
Summary: Kubernetes common files
Group: System/Configuration/Other
BuildArch: noarch
Provides: %prog_name-common = %EVR
Conflicts: %prog_name-common < %EVR
Conflicts: %prog_name-common > %EVR

%description common
Kubernetes is an open source system for managing containerized applications
across multiple hosts; providing basic mechanisms
for deployment, maintenance, and scaling of applications.

This subpackage contains the Kubernetes common files.

%package unit-test
Summary: %summary - for running unit tests
Group: System/Configuration/Other
Provides: %prog_name-unit-test = %EVR
Conflicts: %prog_name-unit-test < %EVR
Conflicts: %prog_name-unit-test > %EVR

Requires: golang >= 1.20
Requires: etcd >= 2.0.9
Requires: hostname
Requires: rsync

%description unit-test
%summary - for running unit tests

%package master
Summary: Kubernetes services for master host
Group: System/Configuration/Other
Provides: %prog_name-master = %EVR
Conflicts: %prog_name-master < %EVR
Conflicts: %prog_name-master > %EVR

Requires: %prog_name-client = %EVR
# if node is installed with node, version and release must be the same
Conflicts: %prog_name-node < %EVR
Conflicts: %prog_name-node > %EVR

%description master
Kubernetes services for master host.

%package node
Summary: Kubernetes services for node host
Group: System/Configuration/Other
Provides: %prog_name-node = %EVR
Conflicts: %prog_name-node < %EVR
Conflicts: %prog_name-node > %EVR

Requires: conntrack-tools
Requires: ethtool
Requires: iptables
Requires: socat
Requires: %prog_name-client = %EVR
Requires: %prog_name-kubelet = %EVR
# if master is installed with node, version and release must be the same
Conflicts: %prog_name-master < %EVR
Conflicts: %prog_name-master > %EVR

%description node
Kubernetes services for node host.

%package kubelet
Summary: Kubernetes kubelet daemon
Group: System/Configuration/Other
Provides: %prog_name-kubelet = %EVR
Conflicts: %prog_name-kubelet < %EVR
Conflicts: %prog_name-kubelet > %EVR

Requires: %prog_name-common = %EVR
# if master is installed with node, version and release must be the same
Conflicts: %prog_name-master < %EVR
Conflicts: %prog_name-master > %EVR

%description kubelet
Kubernetes kubelet service.

%package  kubeadm
Summary:  Kubernetes tool for standing up clusters
Group: System/Configuration/Other
Provides: %prog_name-kubeadm = %EVR
Conflicts: %prog_name-kubeadm < %EVR
Conflicts: %prog_name-kubeadm > %EVR

Requires: %prog_name-node = %EVR
Requires: cni-plugins >= 0.7.5
Requires: ebtables
Requires: iptables
Requires: ethtool
Requires: socat

%description kubeadm
Kubernetes tool for standing up clusters.

%package client
Summary: Kubernetes client tools
Group: System/Configuration/Other
Provides: %prog_name-client = %EVR
Conflicts: %prog_name-client < %EVR
Conflicts: %prog_name-client > %EVR

Requires: %prog_name-common = %EVR

%description client
Kubernetes client tools like kubectl

%package crio
Summary: Kubernetes crio files
Group: System/Configuration/Other
BuildArch: noarch
Provides: %prog_name-crio = %EVR
Conflicts: %prog_name-crio < %EVR
Conflicts: %prog_name-crio > %EVR

Requires: cri-o%kubernetes_major.%kubernetes_minor

%description crio
Packege contains files specific for using crio.

%prep
%setup -q
%autopatch -p1

%build
export GOTOOLCHAIN=local
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export KUBE_GIT_COMMIT=%release
export KUBE_GIT_TREE_STATE="clean"
export KUBE_GIT_VERSION="v%version"

# Fixes https://github.com/golang/go/issues/58425
%ifarch %arm
export CGO_ENABLED=0
%endif

%golang_prepare
# .go-version is needed for successfull build
cp -alv -- .go-version "$BUILDDIR/src/$IMPORT_PATH"
pushd .gopath/src/%import_path
export KUBE_EXTRA_GOPATH=$(pwd)/Godeps/_workspace

GOMAXPROCS=10 make WHAT="${BINS[*]}"

# convert md to man
./hack/update-generated-docs.sh || true
pushd docs
pushd admin
cp kube-apiserver.md kube-controller-manager.md kube-proxy.md kube-scheduler.md kubelet.md ..
popd
cp %SOURCE2 genmanpages.sh
bash genmanpages.sh
popd
popd

%install
export BUILDDIR="$PWD/.gopath"
export GOPATH="%go_path"

cd .gopath/src/%import_path
%ifarch ppc64le aarch64 loongarch64
output_path="_output/local/go/bin"
%else
output_path="_output/local/bin/linux/%go_hostarch"
%endif

install -m 755 -d %buildroot%_bindir

echo "+++ INSTALLING kubeadm"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kubeadm
install -d -m 755 %buildroot%_sysconfdir/systemd/system/kubelet.service.d
install -p -m 644 -t %buildroot/%_sysconfdir/systemd/system/kubelet.service.d %SOURCE4

echo "+++ INSTALLING kubelet and kubelet"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kubelet

echo "+++ INSTALLING kubelet and kubectl"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kubectl

echo "+++ INSTALLING kubelet and kube-apiserver"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kube-apiserver

echo "+++ INSTALLING kubelet and kube-controller-manager"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kube-controller-manager

echo "+++ INSTALLING kubelet and kube-scheduler"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kube-scheduler

echo "+++ INSTALLING kubelet and kube-proxy"
install -p -m 755 -t %buildroot%_bindir ${output_path}/kube-proxy

# install the bash completion
install -d -m 0755 %buildroot%_datadir/bash-completion/completions/
%buildroot%_bindir/kubectl completion bash > %buildroot%_datadir/bash-completion/completions/kubectl
# install the zsh completion
install -d -m 0755 %buildroot%_datadir/zsh/site-functions/
%buildroot%_bindir/kubectl completion zsh > %buildroot/%_datadir/zsh/site-functions/_kubectl

# systemd service
install -d -m 0755 %buildroot%_unitdir
for src in %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 %SOURCE14 ; do
  install -m 0644 -t %buildroot%_unitdir/ "$src"
done

# install manpages
install -d %buildroot%_man1dir
install -p -m 644 docs/man/man1/* %buildroot%_man1dir

# install config files
install -d -m 0775 %buildroot%_sysconfdir/%prog_name
for src in %SOURCE20 %SOURCE21 %SOURCE22 %SOURCE23 %SOURCE24 %SOURCE25 ; do
  install -m 0644 -t %buildroot%_sysconfdir/%prog_name "$src"
done

# install home dir kube user
install -d -m 0775 %buildroot%_localstatedir/%prog_name
# manifests file for the kubelet
install -d -m 0775 %buildroot%_sysconfdir/%prog_name/manifests

# place kubernetes.tmpfiles to /lib/tmpfiles.d/kubernetes.conf
install -d -m 0755 %buildroot%_tmpfilesdir
install -D -m 0644 %SOURCE26 %buildroot%_tmpfilesdir/kubernetes.conf

# load needed module
install -D -m 0644 %SOURCE27 %buildroot%_modulesloaddir/crio.conf

# install sysctl settings
install -D -m 0644 %SOURCE28 %buildroot%_sysctldir/99-kubernetes-cri.conf

# install the place the kubelet defaults to put volumes
install -d %buildroot%_localstatedir/kubelet

# enable CPU and Memory accounting
install -d -m 0755 %buildroot/%_sysconfdir/systemd/system.conf.d
install -p -m 0644 -t %buildroot/%_sysconfdir/systemd/system.conf.d %SOURCE3

%pre common
groupadd -r -f kube > /dev/null 2>&1 ||:
useradd -r -g kube -M -d %_localstatedir/%prog_name -s /dev/null -c "Kubernetes user" kube > /dev/null 2>&1 ||:

%post master
%post_systemd kube-apiserver.service
%post_systemd kube-scheduler.service
%post_systemd kube-controller-manager.service

%preun master
%preun_systemd kube-apiserver.service
%preun_systemd kube-scheduler.service
%preun_systemd kube-controller-manager.service

%post kubelet
%post_systemd kubelet.service

%preun kubelet
%preun_systemd kubelet.service

%post node
%post_systemd kube-proxy.service

%preun node
%preun_systemd kube-proxy.service

%post crio
if [ -f /etc/net/sysctl.conf ]; then
    sed \
        -i.kubernetes-crio \
        -e 's/^net.ipv4.ip_forward = 0$/# net.ipv4.ip_forward = 0/' \
        /etc/net/sysctl.conf
fi

%files common
%attr(775,root,kube) %dir %_sysconfdir/%prog_name
%config(noreplace) %_sysconfdir/%prog_name/config
%_tmpfilesdir/%prog_name.conf
%attr(775,kube,kube) %dir %_localstatedir/%prog_name

%files master
%doc README.md LICENSE
%_man1dir/kube-apiserver.*
%_man1dir/kube-controller-manager.*
%_man1dir/kube-scheduler.*
%_bindir/kube-apiserver
%_bindir/kube-controller-manager
%_bindir/kube-scheduler
%_unitdir/kube-apiserver.service
%_unitdir/kube-controller-manager.service
%_unitdir/kube-scheduler.service
%config(noreplace) %_sysconfdir/%prog_name/apiserver
%config(noreplace) %_sysconfdir/%prog_name/scheduler
%config(noreplace) %_sysconfdir/%prog_name/controller-manager

%files node
%doc README.md LICENSE
%_man1dir/kube-proxy.*
%_bindir/kube-proxy
%_unitdir/kube-proxy.service
%config(noreplace) %_sysconfdir/%prog_name/proxy
%config(noreplace) %_sysconfdir/systemd/system.conf.d/kubernetes-accounting.conf

%files kubelet
%doc README.md LICENSE
%_man1dir/kubelet.*
%_bindir/kubelet
%_unitdir/kubelet.service
%dir %_localstatedir/kubelet
%config(noreplace) %_sysconfdir/%prog_name/kubelet
%attr(775,root,kube) %dir %_sysconfdir/%prog_name/manifests

%files kubeadm
%doc README.md LICENSE
%_man1dir/kubeadm*
%_bindir/kubeadm
%dir %_sysconfdir/systemd/system/kubelet.service.d
%config(noreplace) %_sysconfdir/systemd/system/kubelet.service.d/10-kubeadm.conf

%files client
%doc README.md LICENSE
%_man1dir/kubectl*
%_bindir/kubectl
%_datadir/bash-completion/completions/kubectl
%_datadir/zsh/site-functions/_kubectl

%files crio
%_modulesloaddir/crio.conf
%_sysctldir/99-kubernetes-cri.conf

%changelog
