Name: ladspa_sdk
Version: 1.17
Release: alt1

Summary: The Linux Audio Developer's Simple Plugin API (LADSPA)
License: LGPL-2.1
Group: Sound

Url: http://www.ladspa.org
Source: http://www.ladspa.org/download/%{name}_%version.tgz
Patch: %name-1.16-alt-Makefile.patch

Requires: common-licenses
Requires: rpm-macros-%name = %version-%release

BuildRequires: gcc-c++ libsndfile-devel %_bindir/sndfile-play time

%description
The Linux Audio Developer's Simple Plugin API (LADSPA) attempts
to give programmers the ability to write simple `plugin' audio
processors in C/C++ and link them dynamically against a range of
host applications.

%define _ladspa_path %_libdir/ladspa
%define _ladspa_datadir %_datadir/ladspa

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
# uncomment if macros are platform-neutral
#BuildArch: noarch
# helps old apt to resolve file conflict at dist-upgrade (thanks to Stanislav Ievlev)
Conflicts: ladspa_sdk <= 1.13-alt1

%description -n rpm-macros-%name
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup -n %{name}_%version
%patch -p1 -b .makefile

%build
%define _optlevel 3
%ifarch %e2k
# Some plugins use C++ and need lcxa. It can't be loaded
# dynamically, so all binaries should be linked with it.
cc --version | grep -q '^lcc:1.21' && export LIBS+=" -lcxa"
# lcc: "analyseplugin.c", line 353: error: nonstandard first parameter
#   "const int" of "main", expected "int" [-Werror=main]
%else
%add_optflags -Werror %(getconf LFS_CFLAGS)
%endif
pushd src
%make_build CFLAGS="\$(INCLUDES) -fPIC %optflags $LIBS"
popd

%install
mkdir -p %buildroot%_datadir/ladspa/rdf
pushd src
%makeinstall_std PREFIX=%_prefix INSTALL_PLUGINS_DIR=%_ladspa_path
popd

# install docs and license
rm -f doc/COPYING
ln -sf %_licensedir/LGPL-2 COPYING
ln -sf %_includedir/ladspa.h doc/ladspa.h.txt
ln -sf doc/index.html index.html

# Applications using LADSPA-plugins needs environment variable LADSPA_PATH.
cat << __SH__ >ladspa.sh
# where LADSPA plugins installed
LADSPA_PATH="%_ladspa_path"
export LADSPA_PATH
__SH__

cat << __CSH__ >ladspa.csh
# where LADSPA plugins installed
setenv LADSPA_PATH "%_ladspa_path"
__CSH__

install -d %buildroot%_sysconfdir/profile.d
install -pm755 ladspa.{sh,csh} %buildroot%_sysconfdir/profile.d

# Creating ladspa_sdk buildreq filter
cat <<__BUILDREQS__ > %name.buildreq
# ladspa buildreq filter.
^%_ladspa_path
__BUILDREQS__

install -pDm644 %name.buildreq %buildroot%_sysconfdir/buildreqs/files/ignore.d/ladspa

# rpm macros for ladspa related software
cat <<__RPM_MACROS__ >ladspa.rpm_macros
%%_ladspa_path %%_libdir/ladspa
%%_ladspa_datadir %%_datadir/ladspa
__RPM_MACROS__

install -pDm644 ladspa.rpm_macros %buildroot%_rpmlibdir/macros.d/%name

%files
%_bindir/*
%_includedir/ladspa.h
%_ladspa_path
%dir %_ladspa_datadir
%dir %_ladspa_datadir/rdf
%_sysconfdir/profile.d/*
%_rpmlibdir/macros.d/*
%config %_sysconfdir/buildreqs/files/ignore.d/*
%doc --no-dereference index.html doc README COPYING
%exclude %_rpmmacrosdir/*

%files -n rpm-macros-%name
%_rpmmacrosdir/*

%changelog
