%def_disable snapshot
%define rname atkmm
%define ver_major 2.36
%define api_ver %ver_major

%def_enable docs
%def_enable check

Name: lib%rname%api_ver
Version: %ver_major.3
Release: alt1

Summary: A C++ interface for ATK library
License: LGPL-2.1-or-later
Group: System/Libraries
Url: http://atkmm.sourceforge.net/

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%ver_major/%rname-%version.tar.xz
%endif

Provides: %rname-%api_ver = %version

%define glibmm_api_ver 2.68
%define glibmm_ver 2.68.0
%define atk_ver 2.33.3

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ mm-common
BuildRequires: libatk-devel >= %atk_ver libglibmm%glibmm_api_ver-devel >= %glibmm_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
ATK, the Accessibility Tookit, is used to obtain accessibily information
from GTK+ and GNOME widgets.

ATKmm provides a C++ interface to the ATK library.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %EVR
Provides: %rname-%api_ver-devel = %version

%description devel
This package contains the static libraries and header files needed for
developing atkmm applications.

%package devel-doc
Summary: Documentation for developing with %name
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains the documentation for
developing atkmm applications.

%prep
%setup -n %rname-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/*.so.*
%doc README.* NEWS

%files devel
%_includedir/%rname-%api_ver
%_libdir/*.so
%_libdir/%rname-%api_ver
%_pkgconfigdir/*.pc

%if_enabled docs
%files devel-doc
%_datadir/devhelp/books/%rname-%api_ver
%_docdir/%rname-%api_ver
%endif

%changelog
