%def_enable snapshot

%define ver_major 2.24
%def_disable static
%def_enable check

Name: libbonoboui
Version: %ver_major.5
Release: alt2

Summary: Bonobo user interface components
License: LGPL-2.0-or-later
Group: System/Libraries
Url: ftp://ftp.gnome.org

Vcs: https://gitlab.gnome.org/Archive/libbonoboui.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

# From configure.in
%define libgnomecanvas_ver 1.116.0
%define libbonobo_ver 2.13.0
%define libgnome_ver 2.13.7
%define libxml2_ver 2.4.20
%define gconf_ver 1.1.9
%define gtk_ver 2.6.0
%define glib_ver 2.6.0
%define glade_ver 1.99.11
%define gtk_doc_ver 1.0

BuildPreReq: rpm-build-gnome gnome-common

# From configure.in
BuildRequires: intltool >= 0.40.0
BuildRequires: libpango-devel libpopt-devel
BuildRequires: libXt-devel libX11-devel
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libbonobo-devel >= %libbonobo_ver
BuildRequires: libgnomecanvas-devel >= %libgnomecanvas_ver
BuildRequires: libgnome-devel >= %libgnome_ver
BuildRequires: libgtk+2-devel >= %gtk_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libglade-devel >= %glade_ver
BuildRequires: libGConf-devel >= %gconf_ver
BuildRequires: gtk-doc >= %gtk_doc_ver
%{?_enable_check:BuildRequires: xvfb-run}

%description
Bonobo is a component system based on CORBA, used by the GNOME
desktop. libbonoboui contains the user interface related components
that come with Bonobo.

%package devel
Summary: Develompment libraries and headers for %name
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains header files used to compile programs that use
libbonoboui.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains development documentation for %name

%if_enabled static
%package devel-static
Summary: Static libraries for %name
Group: Development/GNOME and GTK+
Requires: %name-devel = %EVR

%description devel-static
Bonobo is a component system based on CORBA, used by the GNOME desktop.
libbonoboui contains GUI components that come with Bonobo.

This package contains libraries used to compile statically linked
programs that use %name.
%endif

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup

%build
%add_optflags -Wno-incompatible-pointer-types
%autoreconf
%configure \
    %{subst_enable static} \
    %{?_enable_snapshot:--enable-gtk-doc}
%nil
%make_build

%install
%makeinstall_std

bzip2 -9f ChangeLog NEWS

# development diocumentation.
mkdir -p %buildroot%_docdir/%name-devel-%version
cp doc/{*.txt,*.dtd,*.html,*.xml} %buildroot%_docdir/%name-devel-%version/

%find_lang %name-2.0

%check
xvfb-run %make -k check VERBOSE=1

%files -f %name-2.0.lang
%_libdir/*.so.*
%_libdir/libglade/*/*.so
%dir %_datadir/gnome-2.0
%dir %_datadir/gnome-2.0/ui
%doc AUTHORS ChangeLog* NEWS* README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
# TODO: Maybe move bonobo-browser into a separate package?
%_bindir/bonobo-browser
%_bindir/test-moniker
%_datadir/gnome-2.0/ui/bonobo-browser.xml
%_desktopdir/*
# TODO: And samples, too
%_libdir/bonobo-2.0/samples/*
%bonobo_serversdir/*.server
%_datadir/gnome-2.0/ui/Bonobo_Sample*.xml

%files devel-doc
%_gtk_docdir/*
%_docdir/%name-devel-%version

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/libglade/*/*.a
%endif

%exclude %_libdir/libglade/2.0/*.la

%changelog
