# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%ifarch ppc64le
# ppc64le does not have libFuzzer working.
%def_disable check
%endif

Name: libbpf
Version: 1.4.7
Release: alt1
Summary: Stand-alone build of libbpf from the Linux kernel
Group: System/Libraries
License: BSD-2-Clause or LGPL-2.1
Url: https://github.com/libbpf/libbpf

Source: %name-%version.tar

BuildRequires: libelf-devel
BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: clang
BuildRequires: libstdc++-devel
BuildRequires: /proc
}}


%description
Library to access Linux kernel BPF API.

%package devel
Summary: Libbpf library and headers
Group: Development/C
License: LGPLv2 or BSD
Requires: %name = %EVR

%description devel
Library and header files to build with libbpf.

%prep
%setup

%build
%ifarch x86_64
%add_optflags -fanalyzer -Werror
%endif
cd src
%make_build CFLAGS="%optflags -fPIC" V=1 STATIC_LIBS= CC=gcc

%install
cd src
%makeinstall_std LIBSUBDIR=%_lib STATIC_LIBS=

%check
# libbpf does not provide easy accessible or built-in unit tests.
# Smoke testing with libFuzzer.
clang -Isrc fuzz/bpf-object-fuzzer.c -fsanitize=fuzzer,address,undefined -Lsrc -lbpf
LD_LIBRARY_PATH=$PWD/src ./a.out -verbosity=99 -max_total_time=11

%files
%_libdir/libbpf.so.*

%files devel
%doc LICENSE* README.md
%_includedir/bpf
%_libdir/libbpf.so
%_pkgconfigdir/libbpf.pc

%changelog
