# Error: invalid attempt to declare external version name as default in symbol `comedi_set_buffer_size@@v0.7.18'
# FIXME: #define EXPORT_ALIAS_DEFAULT(a,b,c) __asm__(".symver " #a "," #b "@@v" #c )
%define optflags_lto %nil

%def_with doc
%def_enable python
%def_disable static

%define oname comedilib
%define oversion %(echo "%version" | sed -e "s|\\.|_|g")

Name: libcomedi
Version: 0.12.0
Release: alt2

Summary: Data Acquisition library for the Comedi DAQ driver
Summary(ru_RU.UTF-8): Библиотека получения данных для драйвера Comedi DAQ

License: LGPLv2
Group: Development/Other
Url: http://www.comedi.org

Packager: Vitaly Lipatov <lav@altlinux.ru>
AutoReq: noshell

# Source-url: https://github.com/Linux-Comedi/comedilib/archive/r%oversion.tar.gz
Source: %name-%version.tar

# for correct _localstatedir
BuildRequires: rpm-macros-intro-conflicts

BuildRequires: flex gcc-c++ libstdc++-devel swig
%if_enabled python
BuildRequires: python3-devel
%endif

%if_with doc
BuildRequires: xmlto
%endif

%description
The Linux Control and Measurement Device Interface Library.
Comedilib is the library for the Comedi data acquisition driver
for Linux.  It allows Linux processes to acquire data from
supported DAQ cards, such as those from National Instruments.

%description -l ru_RU.UTF-8
Comedilib -- это библиотека для драйвера получения данных Comedi под Linux.
Она позволяет пользовательским процессам получать данные от поддерживаемых
карт DAQ, например, производимых National Instruments.

%package devel
Summary: The files needed for %name application development
Summary(ru_RU.UTF-8): Файлы, требующиеся для разработки приложений с использованием %name
Group: Development/C
Requires: %name = %EVR
# https://bugzilla.altlinux.org/show_bug.cgi?id=19191
#Requires: kernel-headers-comedi

%description devel
The %name-devel package contains the necessary include files
for developing applications with %name.

See demo dir in the source repository for examples.

%description devel -l ru_RU.UTF-8
Пакет %name-devel содержит необходимые заголовочные файлы
для разработки приложений, которые используют %name.

Посмотрите в каталог demo в исходниках проекта, там есть примеры.

%if_with python-bindings
%package -n python3-module-comedi
Summary: Python interface for %name
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-comedi
Python interface for %name.

%endif

%package devel-static
Summary: Static library for %name application development
Summary(ru_RU.UTF-8): Статическая библиотека для разработки приложений с использованием %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
The %name-devel-static package contains the static library
for developing applications with %name
%description devel-static -l ru_RU.UTF-8
Пакет %name-devel-static содержит статическую библиотеку
для разработки приложений, которые используют %name.

%prep
%setup

%build
%autoreconf
%configure --disable-ruby-binding \
           %{subst_enable static} \
%if_enabled python
           --enable-python-binding
%endif
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS README ChangeLog NEWS doc/FAQ
%_libdir/%name.so.*
%_sbindir/comedi_config
%_bindir/comedi_board_info
%_bindir/comedi_test
%dir %_sysconfdir/pcmcia
%config(noreplace) %_sysconfdir/pcmcia/*
%_man1dir/*
%_man7dir/*
%_man8dir/*


%if_enabled python-bindings
%files -n python3-module-comedi
%python3_sitelibdir/*.so
%python3_sitelibdir/comedi.py*
%endif

%files devel
%_includedir/comedi*
%_libdir/%name.so
%_docdir/%oname/
%_pkgconfigdir/*
%if_with doc
%_man3dir/*
%endif

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%changelog
