# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libdeflate
Version: 1.23
Release: alt1
Summary: Heavily optimized library for DEFLATE/zlib/gzip compression and decompression
License: MIT
Group: System/Libraries
Url: https://github.com/ebiggers/libdeflate

%define valgrind_arches %ix86 x86_64 aarch64
# armh is excluded due to https://bugzilla.altlinux.org/43475
# ppc64le is excluded due to requirement on glibc-core-debuginfo

Source: %name-%version.tar
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: ctest
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
}}

%description
libdeflate is a library for fast, whole-buffer DEFLATE-based compression
and decompression.

The supported formats are:

    DEFLATE (raw)
    zlib (a.k.a. DEFLATE with a zlib wrapper)
    gzip (a.k.a. DEFLATE with a gzip wrapper)

libdeflate is heavily optimized. It is significantly faster than the zlib
library, both for compression and decompression, and especially on x86
processors. In addition, libdeflate provides optional high compression
modes that provide a better compression ratio than the zlib's "level 9".

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
%summary.

%package utils
Summary: Command-line programs which use libdeflate
Group: Archiving/Compression
Requires: %name = %EVR

%description utils
libdeflate itself is a library, but the following command-line programs
which use this library are also provided:

libdeflate-gzip (or libdeflate-gunzip), a program which mostly behaves
like the standard equivalent, except that it does not yet have good
streaming support and therefore does not yet support very large files

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS) -Werror
%ifarch x86_64
%add_optflags -fanalyzer
%endif
# It's sensitive to build options, avoid "Rebuilding due to new settings".
%cmake \
	-DLIBDEFLATE_BUILD_STATIC_LIB=OFF \
	-DLIBDEFLATE_BUILD_TESTS=ON
%cmake_build

%install
%cmake_install

%check
%cmake_build --target test

export PATH=%buildroot%_bindir:$PATH LD_LIBRARY_PATH=%buildroot%_libdir
libdeflate-gzip -V

%ifarch %valgrind_arches
%define valgrind valgrind -q --error-exitcode=2
# Unfortunately `--extra-debuginfo-path=` does not work with %%buildroot.
%else
%define valgrind time
%endif
set -o pipefail
head -11111111c /dev/urandom > test-file
b2sum test-file | tee test-file.b2sum
cp test-file test-file-copy
gzip -c test-file-copy |
	%valgrind libdeflate-gunzip |
	%valgrind libdeflate-gzip |
	gunzip > test-file
b2sum test-file
b2sum --check test-file.b2sum

%files
%doc COPYING
%_libdir/libdeflate.so.*

%files devel
%doc NEWS.md README.md
%_includedir/libdeflate.h
%_libdir/libdeflate.so
%_pkgconfigdir/libdeflate.pc
%_libdir/cmake/libdeflate

%files utils
%_bindir/libdeflate-*

%changelog
