%def_disable snapshot

%define _name libdmapsharing
%define api_ver 4.0
%define namespace Dmap

%def_disable check

Name: %_name%api_ver
Version: 3.9.13
Release: alt1

Summary: A DMAP client and server library (4.0 API)
Group: System/Libraries
License: LGPL-2.1-or-later
Url: http://www.flyn.org/projects/libdmapsharing/

Vcs: https://gitlab.gnome.org/GNOME/libdmapsharing.git

%if_disabled snapshot
Source: http://www.flyn.org/projects/libdmapsharing/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.66
%define soup_api_ver 3.0
%define gst_ver 1.22

BuildRequires(pre): rpm-build-gir rpm-build-vala
BuildRequires: vala-tools gtk-doc
BuildRequires: libgdk-pixbuf-devel libsoup%soup_api_ver-devel >= 3.0.0
BuildRequires: gst-plugins1.0-devel >= %gst_ver libavahi-glib-devel zlib-devel
BuildRequires: gobject-introspection-devel libsoup%soup_api_ver-gir-devel gst-plugins1.0-gir-devel
BuildRequires: libgtk+3-devel libgee0.8-devel
BuildRequires: libcheck-devel

%description
libdmapsharing implements the DMAP protocols. This includes support for
DAAP, DPAP & DACP.

%package devel
Summary: Files needed to develop applications using libdmapsharing
Group: Development/C
Requires: %name = %EVR

%description devel
libdmapsharing implements the DMAP protocols. This includes support for
DAAP and DPAP.  This package provides the libraries, include files, and
other resources needed for developing applications using libdmapsharing.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
libdmapsharing implements the DMAP protocols. This includes support for
DAAP and DPAP.

This package contains development documentation for the %name library.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the %name.

%prep
%setup -n %_name-%version
%{?_enable_snapshot:touch ChangeLog}

# remove pregenerated c-sources
rm -f \
libdmapsharing/dmap-enums.c \
libdmapsharing/dmap-enums.h  \
libdmapsharing/unit-test.stamp \
vala/libdmapsharing-4.0.vapi \
tests/dacplisten.c \
tests/dmapcopy.c \
tests/dmapserve.c \
tests/dpapview.c \
tests/unit-test.c \
tests/vala-*.c

%build
%{?_enable_snapshot:%autoreconf}
%add_optflags %optflags_shared
%configure \
    --disable-static \
    --disable-coverage \
    --with-mdns=avahi \
    --enable-gtk-doc
%nil
%make_build -C %_name
%make_build -C vala
%make -C tests

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_libdir/%_name-%api_ver.so.*
%doc AUTHORS ChangeLog README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.vapi

%files devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%changelog
