# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/doxygen gcc-c++
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

%define qt4 0
%define qt5 1
#define tests 1

Name:		libechonest
Version: 	2.3.1
Release:	alt1
Summary:	C++ wrapper for the Echo Nest API

License:	GPLv2+
URL:		https://projects.kde.org/projects/playground/libs/libechonest
#	http://files.lfranchi.com/libechonest-%{version}.tar.bz2
Source0:	libechonest-%{version}.tar

BuildRequires:	ctest cmake
%if 0%{?qt4}
BuildRequires:	pkgconfig(QJson)
BuildRequires:	pkgconfig(QtNetwork)
%endif
%if 0%{?qt5}
BuildRequires:  pkgconfig(Qt5Network)
%endif
Source44: import.info


%description
libechonest is a collection of Qt4 classes designed to make a developer's
life easy when trying to use the APIs provided by The Echo Nest.

%package	devel
Group: Development/C
Summary:	Development files for %{name}
Requires:	%{name} = %{version}-%{release}
%description	devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%if 0%{?qt5}
%package -n libechonest-qt5
Group: System/Libraries
Summary: libechonest Qt5 bindings
%description -n libechonest-qt5
libechonest is a collection of Qt5 classes designed to make a developer's
life easy when trying to use the APIs provided by The Echo Nest.

%package -n libechonest-qt5-devel
Group: System/Libraries
Summary: Development files for libechonest-qt5
Requires: libechonest-qt5 = %{version}-%{release}
%description -n libechonest-qt5-devel
%{summary}.
%endif


%prep
%setup -q


%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"

%if 0%{?qt4}
%global _vpath_builddir %{_target_platform}
%{fedora_v2_cmake} .. \
  -DBUILD_WITH_QT4:BOOL=ON \
  -DECHONEST_BUILD_TESTS:BOOL=%{?tests:ON}%{!?tests:OFF}
%fedora_v2_cmake_build
%endif

%if 0%{?qt5}
%global _vpath_builddir %{_target_platform}-qt5
%{fedora_v2_cmake} .. \
  -DBUILD_WITH_QT4:BOOL=OFF \
  -DECHONEST_BUILD_TESTS:BOOL=%{?tests:ON}%{!?tests:OFF} 
%fedora_v2_cmake_build
%endif


%install
%if 0%{?qt5}
make install/fast DESTDIR=%{buildroot} -C %{_target_platform}-qt5
%endif
%if 0%{?qt4}
make install/fast DESTDIR=%{buildroot} -C %{_target_platform}
%endif


%check
export PKG_CONFIG_PATH=%{buildroot}%{_libdir}/pkgconfig
%if 0%{?qt4}
test "$(pkg-config --modversion libechonest)" = "%{version}" 
%endif
%if 0%{?qt5}
test "$(pkg-config --modversion libechonest5)" = "%{version}"
%endif
## The tests need active internet connection, which is not available in koji builds
%if 0%{?tests}
time make test -C %{_target_platform} ARGS="--timeout 300 --output-on-failure" ||:
%endif




%if 0%{?qt4}
%files
%doc AUTHORS COPYING README TODO
%{_libdir}/libechonest.so.2.3*
%files devel
%{_includedir}/echonest/
%{_libdir}/libechonest.so
%{_libdir}/pkgconfig/libechonest.pc
%endif

%if 0%{?qt5}
%files -n libechonest-qt5
%doc AUTHORS COPYING README TODO
%{_libdir}/libechonest5.so.2.3*
%files -n libechonest-qt5-devel
%{_includedir}/echonest5/
%{_libdir}/libechonest5.so
%{_libdir}/pkgconfig/libechonest5.pc
%endif


%changelog
