%def_disable snapshot
%def_enable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}
%def_enable check

%define Name Exempi
%define _name exempi

Name: lib%_name
Version: 2.6.5
Release: alt1

Summary: Library for easy parsing of XMP metadata
Group: System/Libraries
License: BSD-3-Clause
Url: https://libopenraw.freedesktop.org/exempi/

%if_disabled snapshot
Source: http://libopenraw.freedesktop.org/download/%_name-%version.tar.xz
%else
Vcs: https://gitlab.freedesktop.org/libopenraw/exempi.git
Source: %_name-%version.tar
%endif

%define boost_ver 1.60
BuildRequires: boost-test-devel >= %boost_ver gcc-c++ libexpat-devel zlib-devel

%description
%Name provides a library for easy parsing of XMP metadata. It is a
port of Adobe XMP SDK to work on UNIX.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name%{?_disable_shared:-devel-static} = %version-%release

%description devel
This package contains the libraries and header files needed for
developing with %name.

%if_enabled static
%package devel-static
Summary: Static library for developing programs that will use %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains the static library needed for developing with
%name.
%endif


%prep
%setup -n %_name-%version
# fix boost.m4 for gcc < 5, lcc < 1.23
sed -i~ 's|\^\(boost-lib-version\)|\1|' m4/boost.m4

%build
%autoreconf
%configure  \
    %{subst_enable static} \
    CPPFLAGS="-DBanAllEntityUsage=1"
%make_build

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_bindir/%_name
%_libdir/*.so.*
%_man1dir/%_name.1.*
%doc AUTHORS ChangeLog NEWS README*

%files devel
%_includedir/%_name-2.0/
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif


%changelog
