%define _unpackaged_files_terminate_build 1

Name: libffado
Version: 2.4.8
Release: alt1.2

Summary: Free firewire audio driver library
License: GPLv2+
Group: Sound

Url: http://www.ffado.org/
Source: %name-%version.tar
Patch: libffado-2.4.7-alt.patch

BuildRequires: gcc-c++
BuildRequires: libdbus-devel libexpat-devel libiec61883-devel libxml++2-devel
BuildRequires: libalsa-devel
BuildRequires: pkgconfig(jack)
BuildRequires: libdbus-c++-devel
BuildRequires: qt5-dbus
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3-module-PyQt5-devel python3-module-dbus
# A copy of the imp module that was removed in Python 3.12.
# It shouldn't be used, should use `importlib.metadata` instead.
BuildRequires: python3-module-zombie-imp
BuildRequires: scons xdg-utils libconfig-c++-devel

%description
The FFADO project aims to provide a generic, open-source solution for the
support of FireWire based audio devices for the Linux platform. It is the
successor of the FreeBoB project.

%package devel
Summary: Free firewire audio driver library development headers
Group: Development/C
Requires: %name = %EVR

%description devel
Development files needed to build applications against libffado.

%package -n ffado
Summary: Free firewire audio driver library applications and utilities
Group: Sound
Requires: %name = %EVR

%description -n ffado
Applications and utilities for use with libffado.

%package -n python3-module-ffado
Summary: Python 3 bindings for %name, %summary
Group: Development/Python3
Buildarch: noarch

%description -n python3-module-ffado
Python 3 bindings for %name, %summary

%prep
%setup
%autopatch -p2
cp -at admin/ -- /usr/share/gnu-config/config.guess

# XXX this uses non-existing module and is not used itself!
rm support/mixer-qt4/ffado/mixer/nodevice.py

# We don't want to install all tests
sed -i '/Install/d' tests/{,*/}SConscript

# Fix Python shebangs
sed -i 's|/usr/bin/.*python$|/usr/bin/python3|' \
    admin/*.py doc/SConscript tests/python/*.py tests/*.py \
    support/mixer-qt4/ffado-mixer* support/mixer-qt4/SConscript \
    support/tools/*.py support/tools/SConscript

sed -i 's|-m32||' SConstruct

%build
export CFLAGS="%optflags"
export CXXFLAGS="%optflags --std=gnu++11"
[ -n "$NPROCS" ] || NPROCS=%__nprocs;
scons -j$NPROCS \
	PREFIX=%prefix \
	LIBDIR=%_libdir \
	WILL_DEAL_WITH_XDG_MYSELF=YES \
	CFLAGS='%optflags' \
	CXXFLAGS='%optflags' \
	CUSTOM_ENV=True \
	ENABLE_OPTIMIZATIONS=True \
	MANDIR=%_mandir \
	PYPKGDIR=%python3_sitelibdir_noarch/ \
	PYTHON_INTERPRETER=%__python3

%install
scons \
	PREFIX=%prefix \
	LIBDIR=%_libdir \
	WILL_DEAL_WITH_XDG_MYSELF=YES \
	CFLAGS='%optflags' \
	CXXFLAGS='%optflags' \
	CUSTOM_ENV=True \
	MANDIR=%_mandir \
	DESTDIR=%buildroot install

# remove unpackaged files
rm -f %buildroot%_libdir/libffado/static_info.txt
rm -f %buildroot%_datadir/metainfo/ffado-mixer.appdata.xml

%files
%doc AUTHORS ChangeLog LICENSE.* README
%_libdir/libffado.so.*

%files devel
%dir %_includedir/libffado
%_includedir/libffado/*.h
%_pkgconfigdir/libffado.pc
%_libdir/libffado.so

%files -n ffado
%_bindir/*
%_man1dir/*
%dir %_datadir/libffado
%_datadir/libffado/*
%_datadir/dbus-1/services/org.ffado.Control.service
/lib/udev/rules.d/*ffado*.rules

%files -n python3-module-ffado
%python3_sitelibdir_noarch/ffado

%changelog
