Name: libgflags
Summary: A commandline flags library that allows for distributed flags
Version: 2.2.2
Release: alt3
Group: System/Libraries
Url: http://gflags.github.io/gflags/
License: BSD

Source: v%version.tar
Patch1: gflags-fix_pkgconfig.patch
Patch2: gflags-2.2.2-alt-fix-install_prefix_rel2config_dir.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake ctest

%description
The %name package contains a library that implements commandline flags
processing.  As such it's a replacement for getopt().  It has increased
flexibility, including built-in support for C++ types like string, and
the ability to define flags in the source file in which they're used.

%package devel
Summary: A commandline flags library that allows for distributed flags
Group: Development/C++
Requires: %name = %EVR

%description devel
The %name-devel package contains static and debug libraries and header
files for developing applications that use the %name package.

%prep
%setup -n gflags-%version
%patch1 -p1
%patch2 -p2

mv BUILD BUILD.txt

%build
%cmake \
  -DBUILD_SHARED_LIBS:BOOL=ON \
  -DINSTALL_HEADERS:BOOL=ON \
  -DBUILD_TESTING:BOOL=ON \
  -DREGISTER_BUILD_DIR:BOOL=OFF \
  -DREGISTER_INSTALL_PREFIX:BOOL=OFF
%cmake_build

%install
%cmake_install

%check
%ctest

%files
%doc AUTHORS.txt COPYING.txt
%_libdir/*.so.*
%_bindir/gflags_completions.sh

%files devel
%doc README.md BUILD.txt ChangeLog.txt
%_includedir/gflags
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/*

%changelog
