%def_enable snapshot

%define ver_major 3.12
%def_disable static
%{?_enable_snapshot:%def_enable gtk_doc}
%def_disable debug
%def_enable introspection
%def_disable vala
%def_disable check

Name: libgnome-keyring
Version: %ver_major.0
Release: alt3

Summary: Compatibility library for accessing secrets
License: LGPL
Group: System/Libraries
Url: http://www.gnome.org

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Source1: %name.map

%define glib_ver 2.16.0
%define dbus_ver 1.0
%define gcrypt_ver 1.2.2

# From configure.in
BuildPreReq: intltool >= 0.35.0
BuildPreReq: glib2-devel >= %glib_ver libgio-devel
BuildPreReq: libdbus-devel >= %dbus_ver
BuildPreReq: libgcrypt-devel >= %gcrypt_ver
BuildRequires: gtk-doc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}

# for check
BuildRequires: /proc xvfb-run

%description
The %name library is used by applications to integrate with the
gnome-keyring system.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains headers and development libraries for %name.

%package devel-static
Summary: Static version of %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides libraries for develop programs statically linked
against %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains development documentation for %name

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for %name

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for %name

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup

install -p -m644 %SOURCE1 library/%name-altlinux.ver

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static} \
	%{subst_enable debug} \
	%{subst_enable vala}
%make_build

# X11 required for tests
%check
xvfb-run %make check

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_libdir/*.so.*
%doc README AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%{?_enable_vala:%_vapidir/gnome-keyring-1.vapi}

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files devel-doc
%_gtk_docdir/*

%if_enabled introspection
%files gir
%_typelibdir/GnomeKeyring-1.0.typelib

%files gir-devel
%_girdir/GnomeKeyring-1.0.gir
%endif

%changelog
