%define _name gssdp
%define ver_major 1.6
%define namespace GSSDP
%define api_ver 1.6

%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable sniffer
%ifarch %e2k
%def_disable man
%else
%def_enable man
%endif
# no ipv6 in hasher
%def_disable check

Name: lib%_name%api_ver
Version: %ver_major.4
Release: alt1

Summary: Resource discovery and announcement over SSDP
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://www.gupnp.org/

Vcs: https://gitlab.gnome.org/GNOME/gssdp.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define meson_ver 0.54
%define glib_ver 2.69
%define soup_api_ver 3.0
%define soup_ver 3.0.6

BuildRequires(pre): rpm-macros-meson >= %meson_ver rpm-build-gir rpm-build-vala
BuildRequires: meson vala-tools
BuildRequires: libgio-devel >= %glib_ver libsoup%soup_api_ver-devel >= %soup_ver
%{?_enable_gtk_doc:BuildRequires: gtk-doc gi-docgen}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libsoup%soup_api_ver-gir-devel}
%{?_enable_sniffer:BuildRequires: libgtk4-devel}
%{?_enable_man:BuildRequires: pandoc}

%description
GSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

%package devel
Summary: Development files for gSSDP library
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides files for development with gSSDP.

%package devel-doc
Summary: Development documentation for gSSDP
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gSSDP implements resource discovery and announcement over SSDP and is part
of gUPnP.

This package provides development documentation for gSSDP.

%package gir
Summary: GObject introspection data for the  library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the  library

%package gir-devel
Summary: GObject introspection devel data for the  library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the GSSDP library

%package -n %_name%ver_major-tools
Summary: Graphical SSDP sniffer
Group: Networking/Other
Requires: %name = %EVR

%description -n %_name%ver_major-tools
A Device Sniffer tool based on GSSDP framework.

%prep
%setup -n %_name-%version

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool sniffer sniffer} \
    %{subst_enable_meson_bool man manpages}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/lib%_name-%api_ver.so.*
%doc AUTHORS README* NEWS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%_name-%api_ver
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled sniffer
%files -n %_name%ver_major-tools
%_bindir/%_name-device-sniffer
%{?_enable_man:%_man1dir/%_name-device-sniffer.1.*}
%endif


%changelog
