%define _name gupnp-dlna
%define ver_major 0.12
%define namespace GUPnPDLNA
%define api_ver 2.0

%def_enable introspection
%def_enable vala
%def_enable gtk_doc

Name: libgupnp-dlna
Version: %ver_major.0
Release: alt2
Summary: GUPnP DLNA library

Group: System/Libraries
License: LGPL-2.0-or-later
Url: http://www.gupnp.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: libgio-devel >= 2.58 pkgconfig(libxml-2.0) >= 2.5.0
BuildRequires: pkgconfig(gstreamer-1.0) >= 1.0 pkgconfig(gstreamer-pbutils-1.0) >= 1.0
%{?_enable_introspection:
BuildRequires: pkgconfig(gobject-introspection-1.0) >= 1.36.0 /usr/bin/g-ir-scanner
BuildRequires: gir(GObject) = 2.0 gir(Gst) = 1.0 gir(GstPbutils) = 1.0}
%{?_enable_vala:
BuildRequires: vala-tools >= 0.18 rpm-build-vala libvala-devel
BuildRequires: vapi(libxml-2.0) vapi(gstreamer-pbutils-1.0)
BuildRequires: vapi(gstreamer-1.0) vapi(gstreamer-base-1.0) vapi(gstreamer-video-1.0)}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
GUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The GUPnP API is intended to be easy to use, efficient and flexible.

GUPnP DLNA is a collection of helpers for building DLNA (Digital
Living Network Alliance) compliant applications using GUPnP.

%package devel
Summary: Development package for %_name
Group: Development/Other
Requires: %name = %EVR

%description devel
Contains libraries and header files for developing applications that
use %_name.

%package gir
Summary: GObject introspection data for the %_name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %_name

%package gir-devel
Summary: GObject introspection devel data for the %_name
Group: System/Libraries
BuildArch: noarch
Requires: %name-devel = %EVR
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the %_name

%package devel-doc
Summary: Development package for %_name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Contains developer documentation for %_name.

%prep
%setup -n %_name-%version

%build
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=true}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/*
%_libdir/lib*.so.*
%_datadir/%{_name}*
%_libdir/%_name/*.so
%doc AUTHORS NEWS README TODO

%files devel
%_libdir/lib*.so
%_pkgconfigdir/*.pc
%_includedir/*
%{?_enable_vala:
%_vapidir/*.deps
%_vapidir/*.vapi}

%if_enabled introspection
%files gir
%_typelibdir/%{namespace}*-%api_ver.typelib

%files gir-devel
%_girdir/%{namespace}*-%api_ver.gir
%endif

%{?_enable_gtk_doc:%files devel-doc
%_datadir/gtk-doc/html/*}

%changelog
