%define _name hidapi

Name: libhidapi
Version: 0.15.0
Release: alt1

Summary: Library for communicating with USB and Bluetooth HID devices
License: GPLv3 or BSD
Group: Development/Other
Url: https://github.com/libusb/hidapi
Packager: Yuri N. Sedunov <aris@altlinux.org>

Vcs: https://github.com/libusb/hidapi.git

Source: https://github.com/libusb/hidapi/archive/%_name-%version.tar.gz

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ ctest
BuildRequires: /usr/bin/fox-config
BuildRequires: libudev-devel
BuildRequires: libusb-devel

Provides: hidapi = %EVR

%description
HIDAPI is a multi-platform library which allows an application to interface
with USB and Bluetooth HID-class devices on Windows, Linux, FreeBSD and Mac OS
X. On Linux, either the hidraw or the libusb back-end can be used. There are
trade-offs and the functionality supported is slightly different.

%package devel
Group: Development/C
Summary: Development files for hidapi
Requires: %name = %EVR
Provides: %_name-devel = %EVR

%description devel
This package contains development files for hidapi which provides access to
USB and Bluetooth HID-class devices.

%prep
%setup -n %_name-%_name-%version

%build
%cmake
%cmake_build

%install
%cmake_install

%check
%ctest

%files
%_libdir/lib%_name-*.so.*
%doc AUTHORS.txt README.md LICENSE*.txt

%files devel
%_includedir/%_name/
%_libdir/cmake/%_name
%_libdir/lib%_name-hidraw.so
%_libdir/lib%_name-libusb.so
%_pkgconfigdir/%_name-hidraw.pc
%_pkgconfigdir/%_name-libusb.pc

%changelog
