Name: libjpeg-turbo
Version: 3.0.2
Release: alt2.1
Epoch: 2

Summary: A SIMD-accelerated library for manipulating JPEG image format files
License: BSD-3-Clause
Group: System/Libraries
Url: https://github.com/libjpeg-turbo/libjpeg-turbo

# https://github.com/libjpeg-turbo/libjpeg-turbo/archive/refs/tags/%version.tar.gz
Source: %name-%version-%release.tar
Source2: http://jpegclub.org/jpegexiforient.c
Source3: exifautotran

Patch0: libjpeg-turbo-alt-rdjpgcom-i18n.patch
Patch1: libjpeg-turbo-alt-versioning.patch
Patch2: libjpeg-turbo-fedora-noinst.patch
Patch2000: %name-e2k-simd.patch

BuildRequires: cmake ctest

%ifarch %ix86 x86_64
BuildRequires: nasm
%endif

%package -n libjpeg
Summary: A library for manipulating JPEG image format files
Group: System/Libraries

%package -n libjpeg-devel
Summary: Development tools for programs which will use the libjpeg library
Group: Development/C
Requires: libjpeg = %epoch:%version-%release
Requires: libturbojpeg = %epoch:%version-%release
Provides: libturbojpeg-devel = %epoch:%version-%release
Obsoletes: libturbojpeg-devel
%ifnarch %ix86
Provides: libjpeg-mmx-devel
%endif

%package -n libjpeg-devel-static
Summary: Static libjpeg library
Group: Development/C
Requires: libjpeg-devel = %epoch:%version-%release
%ifnarch %ix86
Provides: libjpeg-mmx-devel-static
%endif

%package -n libjpeg-utils
Summary: Programs for manipulating JPEG format image files
Group: Graphics
Requires: libjpeg = %epoch:%version-%release

%package -n libturbojpeg
Summary: A turbojpeg library
Group: System/Libraries
Requires: libjpeg = %epoch:%version-%release

%description
libjpeg-turbo is a derivative of libjpeg which uses SIMD instructions
(MMX, SSE2, etc.) to accelerate baseline JPEG compression and
decompression on x86 and x86-64 systems.  On such systems, libjpeg-turbo
is generally 2-4x as fast as the unmodified version of libjpeg, all else
being equal.

%description -n libjpeg
This package contains a shared library of functions for loading,
manipulating and saving JPEG format image files.

%description -n libjpeg-devel
This package includes development files necessary for developing
programs which will manipulate JPEG files using the jpeg library.

%description -n libjpeg-devel-static
This package includes static library necessary for developing statically
linked programs which will manipulate JPEG files using the jpeg library.

%description -n libjpeg-utils
This package contains simple client programs for accessing the
libjpeg functions.  Libjpeg client programs include cjpeg, djpeg,
jpegtran, rdjpgcom and wrjpgcom.  Cjpeg compresses an image file
into JPEG format.  Djpeg decompresses a JPEG file into a regular
image file.  Jpegtran can perform various useful transformations
on JPEG files.  Rdjpgcom displays any text comments included in
a JPEG file.  Wrjpgcom inserts text comments into a JPEG file.

%description -n libturbojpeg
This package contains a turbojpeg shared library.

%ifnarch armh i586
%def_enable profiling
%else
%def_disable profiling
%endif

%def_disable static

%prep
%setup -n %name-%version-%release
%patch0 -p2
%patch1 -p1
%patch2 -p2
%ifarch %e2k
%patch2000 -p1
%endif

install -pm644 %_sourcedir/jpegexiforient.c .
install -pm755 %_sourcedir/exifautotran .

# restrict list of global symbols exported by the library.
echo -e '{\nglobal:' > libjpeg.sym
sed -En '/^EXTERN/ s,^.+\)\s+([^(]+).+$,\1;,p' jpeglib.h jpegint.h \
	| egrep -v '^(jinit_|jzero_far)' >> libjpeg.sym
# extra symbols required by packages
cat >> libjpeg.sym <<'EOF'
jinit_c_master_control;
jinit_color_converter;
jinit_master_decompress;
jinit_downsampler;
jpeg_std_message_table;
local: *;
};
EOF

%build
# using PGO makes the code about 10%% faster
# up to 50%% on e2k for progressive JPEG decoding
%if_enabled profiling
%add_optflags -fprofile-generate
%cmake -G'Unix Makefiles' %{?!_enable_static:-DENABLE_STATIC=FALSE}
%cmake_build
# it's better not to do it in parallel
( cd %_cmake__builddir ; make -k test ; make clean )
%remove_optflags -fprofile-generate
%ifarch %e2k
%add_optflags -fprofile-use=%_builddir/%name-%version-%release/%_cmake__builddir/eprof.sum
eprof -d %_cmake__builddir -s %_cmake__builddir/eprof.sum
%else
%add_optflags -fprofile-use
%endif
%endif

%cmake -G'Unix Makefiles' %{?!_enable_static:-DENABLE_STATIC=FALSE}
%cmake_build
make jpegexiforient
bzip2 -9fk libjpeg.txt structure.txt usage.txt

%check
LD_LIBRARY_PATH=%buildroot%_libdir %cmake_build -t test -- -k

%install
%cmake_install
install -pm755 exifautotran jpegexiforient %buildroot%_bindir/
# do not package unwanted libturbojpeg files
find %buildroot -name 'libturbojpeg.*a' -delete

%define docdir %_docdir/%name
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -pm644 README* change.log \
	coderules.txt libjpeg.txt.bz2 structure.txt.bz2 usage.txt.bz2 wizard.txt \
	%buildroot%docdir/

%files -n libjpeg
%_libdir/libjpeg.so.*
%dir %docdir
%docdir/[CLR]*

%files -n libjpeg-utils
%_bindir/*
%_mandir/man?/*

%files -n libjpeg-devel
%_libdir/libjpeg.so
%_libdir/libturbojpeg.so
%_includedir/j*
%_includedir/turbojpeg.h
%dir %docdir
%docdir/[^CLR]*
%_libdir/cmake/libjpeg-turbo
%_pkgconfigdir/libjpeg.pc
%_pkgconfigdir/libturbojpeg.pc

%if_enabled static
%files -n libjpeg-devel-static
%_libdir/libjpeg.a
%endif #static

%files -n libturbojpeg
%_libdir/libturbojpeg.so.*

%changelog
