%define _name lucene++
%def_enable check

Name: lib%_name
Version: 3.0.9
Release: alt2

Summary: A high-performance, full-featured text search engine written in C++
Group: System/Libraries
License: Apache-2.0 or LGPL-3.0-or-later
Url: https://github.com/luceneplusplus/LucenePlusPlus

Source: https://github.com/luceneplusplus/LucenePlusPlus/archive/rel_%version.tar.gz#/%name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: cmake gcc-c++ zlib-devel
BuildRequires: boost-devel boost-filesystem-devel boost-asio-devel boost-interprocess-devel
%{?_enable_check:BuildRequires: libgmock-devel}

%description
An up to date C++ port of the popular Java Lucene library,
a high-performance, full-featured text search engine.

%package devel
Summary: Development files for lucene++
Group: Development/C++
Requires: %name = %EVR

%description devel
Development files for lucene++, a high-performance, full-featured text
search engine written in C++

%prep
%setup
%patch -p1

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
    -DCMAKE_BUILD_TYPE:STRING="Release" \
    %{?_disable_check:-DENABLE_TEST=FALSE} \
    -DBUILD_GMOCK=FALSE} \
    -DINSTALL_GTEST=FALSE
%nil
%cmake_build -t %_name %_name-contrib

%install
%cmake_install

%check
#%%cmake_build -t test

%files
%_libdir/%name.so.*
%_libdir/%name-contrib.so.*
%doc COPYING AUTHORS README* REQUESTS

%files devel
%_includedir/%_name/
%_libdir/%name.so
%_libdir/%name-contrib.so
%_pkgconfigdir/%name.pc
%_pkgconfigdir/%name-contrib.pc
%_libdir/cmake/%{name}*

%changelog
