%define _name libmbim
%define _libexecdir %prefix/libexec

%def_enable introspection

Name: %_name-glib
Version: 1.32.0
Release: alt1

Summary: MBIM modem protocol helper library
License: LGPLv2+
Group: System/Libraries
URL: https://gitlab.freedesktop.org/mobile-broadband/libmbim
Vcs: https://gitlab.freedesktop.org/mobile-broadband/libmbim.git
Source: %name-%version.tar

Patch: %_name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1

BuildRequires: glib2-devel libgio-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
BuildRequires: gtk-doc help2man bash-completion

%define soname 4

%define _unpackaged_files_terminate_build 1

%description
The Mobile Broadband Interface Model (MBIM) is a new standard
to communicate with mobile broadband modem devices developed
by the USB Implementors Forum.
This package contains MBIM modem protocol helper library.

%package utils
Summary: MBIM command line utilities
License: GPLv2+
Group: System/Base
Requires: %name = %version-%release

%description utils
The Mobile Broadband Interface Model (MBIM) is a new standard
to communicate with mobile broadband modem devices developed
by the USB Implementors Forum.
This package contains MBIM command line utilities.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: glib2-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
%summary

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
%summary

%package devel-doc
Summary: This package contains development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: %name-devel = %version-%release

%description devel-doc
This package contains development documentation for %name

%prep
%setup
%patch -p1

%build
%meson \
	%{subst_enable_meson_bool introspection introspection} \
	-Dgtk_doc=true

%meson_build -v

%install
%meson_install

%check
%meson_test

%files
%doc NEWS README.md AUTHORS
%_libdir/%name.so.%soname
%_libdir/%name.so.%soname.*
%_libexecdir/mbim-proxy

%files utils
%_bindir/*
%_man1dir/*
%_datadir/bash-completion/completions/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*.typelib

%files gir-devel
%_datadir/gir-1.0/*.gir
%endif

%files devel-doc
%_datadir/gtk-doc/html/*


%changelog
