Group: Development/Other
%add_optflags %optflags_shared
%define oldname mercator
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libmercator
Version:        0.3.3
Release:        alt1_15
Summary:        Terrain library for WorldForge client/server

License:        GPL+
URL:            http://worldforge.org/dev/eng/libraries/mercator
Source0:        http://downloads.sourceforge.net/worldforge/%{oldname}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libwfmath-devel >= 0.3.2
BuildRequires:  doxygen
Source44: import.info
Provides: mercator = %{version}-%{release}

%description
Mercator is primarily aimed at terrain for multiplayer online games and forms
one of the WorldForge core libraries. It is intended to be used as a terrain
library on the client, while a subset of features are useful on the server.


%package devel
Group: Development/Other
Summary: Development files for mercator library
Requires: %{name} = %{version}-%{release} pkgconfig
Provides: mercator-devel = %{version}-%{release}


%description devel
Development libraries and headers for linking against the mercator library.


%prep
%setup -n %{oldname}-%{version} -q



%build
%configure
%make_build
make docs

# Remove timestamps from the generated documentation to avoid
# multiarch conflicts

for file in doc/html/*.html ; do
    sed -i -e 's/Generated on .* for Mercator by/Generated for Mercator by/' $file
done

%install
%makeinstall_std
rm -f $RPM_BUILD_ROOT%{_libdir}/lib%{oldname}-*.la

%check
# Run tests in debug mode so asserts won't be skipped
sed -i -e 's/-DNDEBUG/-DDEBUG/' tests/Makefile
make %{?_smp_mflags} check




%files
%doc AUTHORS ChangeLog README TODO
%doc --no-dereference COPYING
%{_libdir}/lib%{oldname}-*.so.*


%files devel
%doc doc/html/*
%{_includedir}/Mercator-*
%{_libdir}/lib%{oldname}-*.so
%{_libdir}/pkgconfig/*.pc


%changelog
