%def_with esound
%def_with pulse

Name: libmikmod
Version: 3.3.11.1
Release: alt2

Summary: A portable sound library for Unix
License: GPLv2 and LGPLv2+
Group: System/Libraries

Url: http://mikmod.raphnet.net
# http://download.sourceforge.net/mikmod/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: 0014-playercode-mdreg-Register-the-NULL-driver-before-the.patch
Patch1: use-gnu-install-directories.patch
Patch2: libmikmod-3.3.11.1-hg-include.patch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Thu Mar 03 2011
BuildRequires: libalsa-devel
%{?_with_esound:BuildRequires: libesd-devel}
%{?_with_pulse:BuildRequires: libpulseaudio-devel}
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Libmikmod is a portable sound library, capable of playing samples as
well as module files, originally written by Jean-Paul Mikkers (MikMak)
for DOS. It has subsequently been hacked by many hands and now runs on
many Unix flavours.

It uses the OSS /dev/dsp driver including in all recent kernels for
output, as well as ALSA and EsounD, and will also write wav files.

Supported file formats include mod, stm, s3m, mtm, xm, and it.
Full source included, use of this library for music/sound effects in
your own programs is encouraged!

%package devel
Summary: Header files and libraries for developing apps which will use %name
Group: Development/C
Requires: %name = %version-%release
%{?_with_pulse:Requires: libpulseaudio-devel}

%description devel
Install the %name-devel package if you want to develop applications that
will use the %name library.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p2

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README TODO

%files devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_man1dir/*
%_infodir/*.info*
%_datadir/aclocal/*
%_pkgconfigdir/*.pc

# TODO:
# - consider --enable-simd (marked unstable as of 3.3.7)

%changelog
