# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libmpdclient
Version: 2.22
Release: alt1

Summary: MPD client library

License: BSD-like
Group: System/Libraries
Url: https://www.musicpd.org/
VCS: https://github.com/MusicPlayerDaemon/libmpdclient.git

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: doxygen fontconfig

%description
Library for Music Player Daemon client development.

%package devel
Summary: Header files for the MPD client library
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for MPD client library.

%package devel-docs
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description devel-docs
Development documentation for %name.

%prep
%setup

%build
%meson -D documentation=true
%meson_build

%check
%meson_test

%install
%meson_install

%files
%doc README.rst AUTHORS NEWS LICENSES/{BSD-2-Clause.txt,BSD-3-Clause.txt}
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/mpd/
%_pkgconfigdir/%name.pc

%files devel-docs
%_docdir/%name

%changelog
