Name: liboil
Version: 0.3.17
Release: alt1.qa2

Summary: Library of Optimized Inner Loops
License: BSD-style
Group: System/Libraries
Url: http://liboil.freedesktop.org

# http://git.altlinux.org/gears/l/liboil.git
Source: %name-%version-%release.tar

%define pkgdocdir %_docdir/%name-%version
%def_disable static
%def_enable gtk_doc
%def_enable check

BuildRequires: glib2-devel
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:BuildRequires: /proc}

%description
Liboil is a library of simple functions that are optimized for
various CPUs.  These functions are generally loops implementing simple
algorithms, such as converting an array of N integers to floating-poing
numbers or multiplying and summing an array of N numbers.  Clearly such
functions are candidates for significant optimization using various
techniques, especially by using extended instructions provided by
modern CPUs (Altivec, MMX, SSE, etc.).

Many multimedia applications and libraries already do similar things
internally.  The goal of this project is to consolidate some of the code
used by various multimedia projects, and also make optimizations easier
to use by a broad range of applications.

%package devel
Summary: Development environment for liboil
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files required for building
liboil-based software.

%package devel-doc
Summary: Development documentation for liboil
Group: Development/C
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains development documentation for the liboil library.

%package devel-static
Summary: Static liboil library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains development files required for building
statically linked liboil-based software.

%package examples
Summary: Examples for liboil
Group: Development/C
BuildArch: noarch
Requires: %name-devel = %version-%release

%description examples
This package contains examples for writing applications using
the liboil library.

%prep
%setup -q -n %name-%version-%release

%build
%autoreconf
%configure \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{subst_enable static}

# SMP-incompatible build
make

%install
%makeinstall_std
install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS BUG-REPORTING COPYING README HACKING NEWS \
	%buildroot%pkgdocdir/
make -C examples distclean
cp -a examples %buildroot%pkgdocdir/

%check
make -k -C testsuite check CFLAGS='%optflags -fno-lto'

%files
%_libdir/*.so.*
%pkgdocdir/
%exclude %pkgdocdir/examples

%files devel
%_bindir/oil-bugreport
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files examples
%dir %pkgdocdir
%pkgdocdir/examples/

%changelog
