%define _name openh264
%define sover 7

%def_enable check
%def_with meson

%def_disable static

Name: lib%_name
Version: 2.6.0
Release: alt2

Summary: H.264 codec library
License: BSD-2-Clause
Group: System/Libraries
Url: http://www.openh264.org/

Vcs: https://github.com/cisco/openh264.git
#Source: https://github.com/cisco/openh264/archive/v%version/%_name-%version.tar.gz
Source: %name-%version.tar

%define libname lib%{_name}_%sover
%define sover1 %version

%ifarch %ix86
%set_verify_elf_method textrel=relaxed
%endif

%if_with meson
BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
%endif
BuildRequires: gcc-c++ nasm

%{?_enable_check:BuildRequires: libgtest-devel}

%description
OpenH264 is a codec library which supports H.264 encoding and decoding.
It is suitable for use in real time applications such as WebRTC.

%package -n %libname
Summary: %summary
Group: System/Libraries
Obsoletes: %name < 2.4.1-alt2
Provides: %name = %EVR

%description -n %libname
OpenH264 is a codec library which supports H.264 encoding and decoding.
It is suitable for use in real time applications such as WebRTC.

This package provides shared OpenH264 libraries.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %libname = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-static
Summary: Static H.264 codec library
Group: Development/C++
Requires: %libname-devel = %EVR

%description devel-static
This package provides %name static library.

%prep
%setup
# setup build options
%add_optflags %optflags_shared -fno-strict-aliasing
%ifarch %ix86
%add_optflags -msse2 -mfpmath=sse %(getconf LFS_CFLAGS)
sed -i 's|^USE_ASM[[:space:]][[:space:]]*=.*|USE_ASM = No|' Makefile
sed -i 's|^HAVE_AVX2[[:space:]][[:space:]]*:=.*|HAVE_AVX2 := No|' build/arch.mk
%endif
%ifarch %e2k
sed -i "s/family == 'ppc64'/family == 'e2k'/" {,codec/*/}meson.build
%endif
sed -i -e 's|^CFLAGS_OPT=.*$|CFLAGS_OPT=%{optflags} %(getconf LFS_CFLAGS)|' Makefile
#sed -i -e '/^CFLAGS_OPT=/i LDFLAGS={ldflags}' Makefile
sed -i -e 's|^PREFIX=.*$|PREFIX=%{_prefix}|' Makefile
sed -i -e 's|^LIBDIR_NAME=.*$|LIBDIR_NAME=%{_lib}|' Makefile
sed -i -e 's|^SHAREDLIB_DIR=.*$|SHAREDLIB_DIR=%{_libdir}|' Makefile

%build
%if_with meson
%meson
%meson_build
%else
%make_build
%endif

%install
%if_with meson
%meson_install
%else
%makeinstall_std
%endif

%if_disabled static
%{?_without_meson:rm -v %buildroot%_libdir/%name.a}
%endif

%check
%if_with meson
%__meson_test -t 2
%endif

%files -n %libname
%_libdir/%name.so.%sover
%_libdir/%name.so.%sover1
%doc LICENSE README.md RELEASES

%files devel
%_includedir/wels/
%_libdir/%name.so
%_pkgconfigdir/%_name.pc

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%changelog
