%def_disable snapshot

%define _name openjpeg
%define ver_major 2.5
%define api_ver 2.0
%define libname libopenjp2

%def_enable docs
#x86_64: 99%% tests passed, 2 tests failed out of 1541
%def_disable check

Name: lib%_name%api_ver
Version: %ver_major.4
Release: alt1

Summary: JPEG 2000 codec library (API version 2.0)
License: BSD-2-Clause
Group: System/Libraries
Url: https://www.openjpeg.org/

Vcs: https://github.com/uclouvain/openjpeg.git

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: https://github.com/uclouvain/%_name/archive/v%version/%_name-%version.tar.gz
#Source: %url%_name-%version.tar.gz
%endif
# https://github.com/uclouvain/openjpeg-data.git
# 1.1G
%{?_enable_check:Source1: %_name-data-f9991d5.tar}

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ libtiff-devel libjpeg-devel libwebp-devel
BuildRequires: liblcms2-devel libpng-devel libjbig-devel
BuildRequires: zlib-devel libdeflate-devel liblzma-devel libzstd-devel
%{?_enable_docs:BuildRequires: doxygen graphviz}
%{?_enable_check:BuildRequires: ctest}

%description
OpenJPEG is an open-source JPEG 2000 codec written in C. This package contains
runtime libraries for applications that use OpenJPEG.

%package devel
Summary: Development tools for programs which will use the %name library
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package includes the header files necessary for developing
programs which will use the %name library.

%package -n openjpeg-tools%api_ver
Summary: JPEG 2000 command line tools
Group: Graphics

%description -n openjpeg-tools%api_ver
OpenJPEG is an open-source JPEG 2000 codec written in C.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
#BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
The %name-devel-doc package includes documentation necessary for
developing with %name library.

%prep
%setup -n %_name-%version
%{?_enable_check:mkdir data && tar -xf %SOURCE1 --strip-components=1 -C data/}

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DBUILD_STATIC_LIBS:BOOL=OFF \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    -DOPENJPEG_INSTALL_LIB_DIR=%_lib \
    -DBUILD_THIRDPARTY:BOOL=OFF \
    %{?_enable_docs:-DBUILD_DOC:BOOL=ON} \
    %{?_enable_check:-DBUILD_TESTING=ON \
     -DBUILD_UNIT_TESTS=ON \
     -DOPJ_DATA_ROOT=${PWD}/data}
%nil
%cmake_build

%install
%cmake_install

# to avoid conflict with libopenjpeg-1.x (in <= P10)
for file in %buildroot%_bindir/opj_*; do
    mv $file ${file/opj_/opj2_}
done
%if_enabled docs
mv %buildroot%_man1dir/opj_compress.1 %buildroot%_man1dir/opj2_compress.1
mv %buildroot%_man1dir/opj_decompress.1 %buildroot%_man1dir/opj2_decompress.1
mv %buildroot%_man1dir/opj_dump.1 %buildroot%_man1dir/opj2_dump.1
%endif
# and fix cmake-files
subst 's|opj_\([compess,decompess,dump]\)|opj2_\1|g' %buildroot%_libdir/cmake/%_name-%ver_major/*.cmake

%check
%cmake_build -t test

%files
%_libdir/%libname.so.*
%doc AUTHORS* LICENSE NEWS* README* CHANGELOG*

%files devel
%_includedir/%_name-%ver_major/
%_libdir/%libname.so
%_pkgconfigdir/%libname.pc
%_libdir/cmake/%_name-%ver_major/*.cmake
%{?_enable_docs:%_man3dir/%libname.3.*}

%files -n openjpeg-tools%api_ver
%_bindir/opj2_compress
%_bindir/opj2_decompress
%_bindir/opj2_dump
%{?_enable_docs:%_man1dir/*}

%if_enabled docs
%files devel-doc
%_datadir/doc/%_name/
%endif

%changelog
