%define git %nil

Name: libopus
Version: 1.5.2
Release: alt1

Summary: Opus Audio Codec library
License: BSD
Group: System/Libraries
Url: http://opus-codec.org/
# http://downloads.xiph.org/releases/opus/%name-%version.tar.gz
Source: opus-%version.tar

BuildRequires(pre): meson, cmake

%def_disable static
%def_enable doc

%description
The Opus codec is designed for interactive speech and audio transmission
over the Internet. It is designed by the IETF Codec Working Group and
incorporates technology from Skype's SILK codec and Xiph.Org's CELT codec.

%package devel
Summary: Development files for libopus
Group: Development/C
PreReq: %name = %version-%release
%if_enabled doc
BuildRequires: doxygen, graphviz, fonts-ttf-dejavu
%endif

%description devel
This package contains the header files and documentation needed
to develop applications with libopus.

%package devel-static
Summary: Static libraries for libopus
Group: Development/C
PreReq: %name-devel = %version-%release

%description devel-static
This package contains development libraries required for packaging
statically linked libopus-based software.

%prep
%setup -n opus-%version

%build
printf 'PACKAGE_VERSION="%s"\n' '%version' > package_version
%meson -Dintrinsics=auto \
       -Dcheck-asm=true \
       -Dcustom-modes=true \
%ifarch x86_64
       -Drtcd=disabled \
%endif
%ifarch x86_64 aarch64
       -Ddeep-plc=enabled \
       -Ddred=enabled \
       -Dosce=enabled
%endif
%meson_build

%install
%meson_install

%check
%__meson_test -t 1000

%files
%_libdir/*.so.*
%doc AUTHORS README COPYING LICENSE_PLEASE_READ.txt

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%if_enabled doc
%dir %_docdir/opus/
%_docdir/opus/*
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
