%def_disable snapshot

%define api_ver 2.0

%def_disable python
%def_enable check

Name: libplist
Version: 2.7.0
Release: alt1

Summary: Library for manipulating Apple Binary and XML Property Lists
Group: System/Libraries
License: GPL-2.0 and LGPL-2.1
Url: http://www.libimobiledevice.org/

Vcs: https://github.com/libimobiledevice/libplist.git

%if_disabled snapshot
Source: https://github.com/libimobiledevice/libplist/releases/download/%version/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif
Patch: libplist-2.0.0-alt-e2k-lcc123.patch

BuildRequires: gcc-c++ xml-utils
%{?_enable_python:BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-Cython >= 3.0}

%description
libplist is a library for manipulating Apple Binary and XML Property Lists

%package -n %{name}mm
Summary: Cmm wrapper for %name library
Group: System/Libraries
Requires: %name = %EVR

%description -n %{name}mm
This package provides Cmm interface for %name library

%package -n %{name}mm-devel
Summary: Headers and development files for %{name}mm library
Group: System/Libraries
Requires: %{name}mm = %EVR
Requires: %name-devel = %EVR

%description -n %{name}mm-devel
This package contains the headers and development files that are needed
to develop or compile applications which need %{name}mm library

%package devel
Summary: Development package for libplist
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides development headers and libraries for %name

%package -n python3-module-%name
Summary: Python3 package for libplist
Group: Development/Python3
Requires: %name = %EVR
Requires: %{name}mm = %EVR

%description -n python3-module-%name
Python3 libraries and bindings for %name


%prep
%setup
#%%patch -p1 -b .e2k

%build
%add_optflags %(getconf LFS_CFLAGS) %optflags_shared
%autoreconf
%configure --disable-static CC=gcc \
%{?_enable_python:PYTHON=%__python3} \
%{?_disable_python:--without-cython}

%make_build

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_bindir/plistutil
%_libdir/libplist-%api_ver.so.*
%_man1dir/plistutil.1*
%doc AUTHORS README* NEWS

%files devel
%_includedir/plist/
%_libdir/libplist-%api_ver.so
%_libdir/pkgconfig/libplist-%api_ver.pc
%exclude %_includedir/plist/plist++.h

%files -n %{name}mm
%_libdir/libplist++-%api_ver.so.*

%files -n %{name}mm-devel
%_includedir/plist/plist++.h
%_libdir/libplist++-%api_ver.so
%_pkgconfigdir/libplist++-%api_ver.pc

%if_enabled python
%files -n python3-module-%name
%python3_sitelibdir/plist.so
%exclude %python3_sitelibdir/plist.la
%endif

%changelog
