%def_enable snapshot
%define _name rarian
%define major 0.8
# The version of Scrollkeeper that Rarian obsoletes
%define skversion 0.3.14

%def_disable static
%def_disable check
%{?_enable_check:%def_with check}

Name: librarian
Version: %major.6
Release: alt1

Summary: A documentation meta-data library

License: GPL-2.0-or-later
Group: System/Libraries
Url: http://rarian.freedesktop.org/

Vcs: https://gitlab.freedesktop.org/rarian/rarian.git
%if_disabled snapshot
Source: https://gitlab.freedesktop.org/rarian/rarian/-/releases/%version/downloads/assets/%_name-%version.tar.bz2
%else
Source: %_name-%version.tar
%endif

Source1: scrollkeeper-omf.dtd
Source2: scrollkeeper-cl.dtd
Source3: scrollkeeper.filetrigger

Provides: %_name-compat = %EVR
Obsoletes: %_name-compat < %version-%release

Provides: scrollkeeper = %skversion.rarian.%version-%release
Provides: libscrollkeeper = %skversion.rarian.%version-%release
Obsoletes: scrollkeeper < %skversion.rarian
Obsoletes: libscrollkeeper < %skversion.rarian

Requires(pre): xml-common, xml-utils, docbook-dtds

BuildRequires(pre): rpm-build-compat rpm-build-licenses
BuildRequires(pre): rpm-build-gnome >= 0.8
BuildRequires: gcc-c++ pkgconfig(tinyxml2) xsltproc
%{?_enable_check:BuildRequires: libcheck-devel man-db info man-pages}

%description
Rarian is a documentation meta-data library that allows access to
documents, man pages and info pages. It was designed as a replacement
for scrollkeeper.

%package devel
Summary: Development files for libRarian
Group: Development/C
Requires: %name = %EVR
Obsoletes: libscrollkeeper-devel < %skversion.rarian

%description devel
This package contains files required to develop applications that use
the Rarian library ("librarian").

%if_enabled static
%package static
Summary: Static Rarian library
Group: Development/C
Requires: %name-devel = %EVR

%description static
Static Rarian library (librarian).
%endif

%prep
%setup -n %_name-%version

%build
echo %version > .tarball-version
export VERSION=%version
# all mainstreams sets localstatedir in var, but ALT sets it in /var/lib :(
%autoreconf
%add_optflags %(getconf LFS_CFLAGS)
export ac_cv_path_have_bash=/bin/bash
%configure \
	%{subst_enable static} \
	--enable-omf-read \
	--disable-skdb-update \
	--localstatedir=%_var \
	%{subst_with check}
%nil
%make_build

%install
install -d %buildroot%_omfdir
install -d %buildroot%_localstatedir/%_name/

%makeinstall_std

# dtds
install -pD -m 644 %SOURCE1 %buildroot%_datadir/xml/scrollkeeper/dtds/scrollkeeper-omf.dtd
install -pD -m 644 %SOURCE2 %buildroot%_datadir/xml/scrollkeeper/dtds/scrollkeeper-cl.dtd

# posttrans filetrigger
install -pD -m 755 %SOURCE3 %buildroot%_rpmlibdir/scrollkeeper.filetrigger

%check
#export LC_ALL=en_US.utf8
export LD_LIBRARY_PATH=%buildroot%_libdir
%make -k check VERBOSE=1

%post
%_bindir/rarian-sk-update
%_bindir/xmlcatalog --noout --add "public" \
        "-//OMF//DTD Scrollkeeper OMF Variant V1.0//EN" \
        "%_datadir/xml/scrollkeeper/dtds/scrollkeeper-omf.dtd" %_sysconfdir/xml/catalog
%_bindir/xmlcatalog --noout --add "public" \
        "-//Scrollkeeper//DTD Contents List V1.0//EN" \
        "%_datadir/xml/scrollkeeper/dtds/scrollkeeper-cl.dtd" %_sysconfdir/xml/catalog
%_bindir/rarian-sk-rebuild -q

%preun
[ $1 = 0 ] || exit 0
%_bindir/xmlcatalog --noout --del \
	"%_datadir/xml/scrollkeeper/dtds/scrollkeeper-omf.dtd" %_sysconfdir/xml/catalog ||:
%_bindir/xmlcatalog --noout --del \
	"%_datadir/xml/scrollkeeper/dtds/scrollkeeper-cl.dtd" %_sysconfdir/xml/catalog ||:

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO MAINTAINERS
%_bindir/rarian-example
%_bindir/rarian-sk-*
%_bindir/scrollkeeper-*
%_libdir/librarian.so.*
%_datadir/librarian/
%_datadir/help/
%_datadir/xml/scrollkeeper/dtds/
%_rpmlibdir/scrollkeeper.filetrigger
%dir %_localstatedir/%_name/
%dir %_omfdir

%files devel
%_libdir/librarian.so
%_includedir/%_name/
%_pkgconfigdir/%_name.pc

%if_enabled static
%files static
%_libdir/librarian.a
%endif

%changelog
