# See also https://github.com/EasyCoding/rlottie/blob/master/rlottie.spec
# TODO: external rapidjson
# see soname version (player version) in CMakeLists.txt
%define soname 0.0.1
Name: librlottie
Version: 0.1.2
Release: alt1

Summary: Platform independent standalone library that plays Lottie Animation

Group: Networking/Instant messaging
License: LGPLv2+ and BSD and MIT

Url: http://www.tizen.org/
Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-git: https://github.com/desktop-app/rlottie.git
Source: %name-%version.tar

Patch1: %name-fix-gcc11.patch

BuildRequires: gcc-c++ cmake

%description
rlottie is a platform independent standalone c++ library
for rendering vector based animations and art in realtime.

Lottie loads and renders animations and vectors exported
in the bodymovin JSON format.
Bodymovin JSON can be created and exported
from After Effects with bodymovin,
Sketch with Lottie Sketch Export, and from Haiku.

For the first time, designers can create and ship beautiful
animations without an engineer painstakingly recreating it by hand.
Since the animation is backed by JSON they are extremely
small in size but can be large in complexity!

%package devel
Group: Development/Other
Summary: Development files for %name

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.


%prep
%setup
%patch1 -p2
%__subst "s|VERSION 0.0.1|VERSION %version.0|" CMakeLists.txt
%__subst "s|-Werror||" CMakeLists.txt

%build
%cmake_insource
%make_build

%install
%makeinstall_std

%files
%_libdir/librlottie-image-loader.so
%_libdir/librlottie.so.0
%_libdir/librlottie.so.%soname

%files devel
%doc COPYING
%_libdir/librlottie.so
%_includedir/rlottie.h
%_includedir/rlottie_capi.h
%_includedir/rlottiecommon.h
%_libdir/cmake/rlottie/
%_pkgconfigdir/rlottie.pc

%changelog
