# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libsavitar
Version: 5.3.0
Release: alt1
Summary: C++ implementation of 3mf loading with SIP Python bindings
License: LGPLv3+
Group: Development/Other
Url: https://github.com/Ultimaker/libSavitar

# Source-url: https://github.com/Ultimaker/%name/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

# Python bits
# Source1-url: https://github.com/Ultimaker/pySavitar/archive/%version.tar.gz
Source1: pySavitar-%version.tar

# Cmake bits taken from 4.13.1, before upstream went nuts with conan
Source2: FindSIP.cmake
Source3: SIPMacros.cmake
Source4: CMakeLists.txt
Source5: SavitarConfig.cmake.in
Source6: COPYING-CMAKE-SCRIPTS
 
# Actually export symbols into the shared lib
Patch0: libsavitar-5.2.2-export-fix.patch

Patch1: find-sip3.patch

BuildRequires(pre): rpm-build-python3 rpm-macros-cmake
BuildRequires: cmake dos2unix gcc-c++ libpugixml-devel python3-devel python3-module-sip-devel %_bindir/sip3

%description
Savitar is a C++ implementation of 3mf loading with SIP Python bindings.
3mf is a 3D printing file format.

%package devel
Summary: Development files for libsavitar
# The cmake scripts are BSD
License: AGPLv3+ and BSD
Group: Development/Other
Requires: %name = %EVR

%description devel
Savitar is a C++ implementation of 3mf loading with SIP Python bindings.
3mf is a 3D printing file format.

Development files.

%package -n python3-module-savitar
Summary: Python 3 libSavitar bindings
Group: Development/Python3
Requires: %name = %EVR
%py3_provides Savitar
Requires: python3-module-PyQt5-sip

%description -n python3-module-savitar
Savitar is a C++ implementation of 3mf loading with SIP Python bindings.
3mf is a 3D printing file format.

The Python bindings.

%prep
%setup -a 1

cp -a pySavitar-%version/python .
mkdir cmake
cp -a %SOURCE2 %SOURCE3 %SOURCE6 cmake/
rm -rf CMakeLists.txt
cp -a %SOURCE4 %SOURCE5 .
%autopatch -p1

# Wrong end of line encoding
dos2unix README.md

# https://github.com/Ultimaker/libSavitar/pull/18
sed -i 's/Python3_SITELIB/Python3_SITEARCH/' cmake/SIPMacros.cmake

%build
%add_optflags '-Wl,--as-needed'
%cmake -DCMAKE_SKIP_RPATH:BOOL=ON
%cmake_build

%install
%cmake_install

%files
%doc README.md
%_libdir/libSavitar.so.*

%files devel
%doc README.md LICENSE
%_libdir/libSavitar.so
%_includedir/Savitar
# Own the dir not to depend on cmake:
%_libdir/cmake

%files -n python3-module-savitar
%doc README.md
%python3_sitelibdir/pySavitar.so

%changelog
