%define major 10

Summary: C++ library for subband sinusoidal modeling time stretching and pitch scaling
Name: libsbsms%major
Version: 2.0.2
Release: alt4
License: GPLv2
Group: System/Libraries
URL: http://sbsms.sourceforge.net/
Source0: %name-%version.tar

Patch1: DEBIAN-set-library-version.patch
Patch2: ALT-e2k-fft.patch
Patch3: GENTOO-cflags.patch
Patch4: ALT-audacity-bug-955.patch
Patch5: ALT-audacity-bug-1808.patch
# Required for --enable-multithreaded
# https://bugzilla.audacityteam.org/show_bug.cgi?id=2492
Patch6:	ALT-audacity-bug-2492.patch

BuildRequires: gcc-c++
BuildRequires: pkgconfig(sndfile)

%description
C++ library for subband sinusoidal modeling time stretching and pitch scaling

%package -n libsbsms-devel
Summary: Development files of C++ library for subband sinusoidal modeling time stretching and pitch scaling
Group: Development/C++
Requires: %name = %EVR

%description -n libsbsms-devel
Development files of the C++ library for subband sinusoidal modeling time stretching and pitch scaling
#--------------------------------------

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p3
%patch5 -p3
%patch6 -p3

%build
# for multithreading
export LIBS="-lpthread"
%autoreconf

%configure \
	--enable-shared \
	--disable-static \
%ifarch %ix86 x86_64 %e2k
	--enable-sse \
%else
	--disable-sse \
%endif
	--enable-multithreaded
	
%make_build

%install
%makeinstall_std
#--------------------------------------

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%_libdir/libsbsms.so.%{major}
%_libdir/libsbsms.so.%{major}.*

%files -n libsbsms-devel
%_pkgconfigdir/*.pc
%_includedir/*
%_libdir/libsbsms.so

#--------------------------------------
%changelog
