Name: libsearpc
Version: 3.2.0.1
Release: alt1

Summary: RPC library for Seafile

Group: Networking/File transfer
License: GPLv3
Url: https://github.com/haiwen/libsearpc

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source-url: https://github.com/haiwen/libsearpc/archive/v%version.tar.gz
# Source-url: https://github.com/haiwen/libsearpc/commit/cb1ffb2676ee0e96e4d416fe062f81b2e212271f
Source: %name-%version.tar

BuildRequires: glib2-devel libjansson-devel

BuildRequires: libgio-devel

BuildRequires: rpm-build-python3 python3-devel

%description
Searpc is a simple C language RPC framework based on GObject system.
Searpc handles the serialization/deserialization part of RPC, the transport part is left to users.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/C

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n python3-module-pysearpc
Summary: Seafile RPC python3 module
Group: Networking/File transfer

%description -n python3-module-pysearpc
Seafile RPC python3 module.


%prep
%setup
# https://github.com/haiwen/libsearpc/pull/20
sed -i 's/(DESTDIR)//' libsearpc.pc.in
sed -i -e 's@#!/usr/bin/env python@#!%__python3@' lib/searpc-codegen.py

%build
%autoreconf
%configure --disable-static --disable-compile-demo --enable-server-pkg PYTHON=%__python3
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS README.markdown
%_libdir/*.so.*

%files -n python3-module-pysearpc
%python3_sitelibdir/pysearpc/

%files devel
%_bindir/searpc-codegen.py
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%name.pc

%changelog
