%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libspf2
Version: 1.2.11
Release: alt1.git.4915c30
Summary: Implementation of the SPF specification
License: LGPLv2.1+
Group: System/Libraries
URL: https://www.libspf2.org/

# https://github.com/shevek/libspf2.git
Source: %name-%version.tar

Patch1: libspf2-alt-disable-static-binaries.patch
Patch2: libspf2-alt-glibc-compat.patch
Patch3: libspf2-alt-print-format.patch

# Automatically added by buildreq on Mon Nov 03 2008
BuildRequires: gcc-c++

%description
Libspf2 is an implementation of the SPF specification as found at
http://tools.ietf.org/html/rfc7208

%package tools
Summary: Tools distributed with libspf2
Group: Networking/Other
Requires: %name = %EVR

%description tools
Tools distributed with libspf2; at the time of writing: spf_example,
spf_example_2mx, spfd, spfquery and spftest.

%package devel
Summary: Development files for libspf2 library
Group: Development/C
Requires: %name = %EVR

%description devel
Development files for libspf2 library.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
	--disable-static \
	%nil

# fix rpath libtool issues
subst 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool || exit 1
subst 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool || exit 1
%make_build

%install
%makeinstall_std

%files
%doc LICENSES
%_libdir/lib*.so.*

%files tools
%_bindir/*

%files devel
%_includedir/*
%_libdir/*.so

%changelog
