%define _unpackaged_files_terminate_build 1

%define upname libtorrent-rasterbar
%define soname 10

Name: libtorrent-rasterbar10
Epoch: 4
Version: 1.2.14
Release: alt3

Summary: libTorrent is a BitTorrent library written in C++ for *nix
License: BSD-3-Clause and BSL-1.0
Group: System/Libraries
Url: https://www.rasterbar.com/products/libtorrent/

# https://github.com/arvidn/libtorrent.git
Source: %name-%version.tar

# Patch from OpenSUSE
Patch1: libtorrent-rasterbar-fix_library_version.patch

Patch2: libtorrent-rasterbar-disable-pkgconfig.patch
Patch3: libtorrent-rasterbar-don-t-append-python-bindings-src-path-to-module-vers.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: libssl-devel
BuildRequires: zlib-devel
BuildRequires: boost-devel boost-asio-devel boost-filesystem
BuildRequires: boost-filesystem-devel boost-program_options-devel
BuildRequires: python3-devel boost-python3-devel
BuildRequires: python3(setuptools)
BuildRequires: libGeoIP-devel

%description
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package devel
Summary: Development libraries and header files for libTorrent
Group: Development/C++
Requires: %name = %EVR
Conflicts: libtorrent-rasterbar8-devel < %EVR
Obsoletes: libtorrent-rasterbar8-devel < %EVR
Conflicts: libtorrent-rasterbar7-devel < %EVR
Obsoletes: libtorrent-rasterbar7-devel < %EVR
Conflicts: libtorrent-devel
Conflicts: %upname-devel

%description devel
The libtorrent-devel package contains libraries and header files needed
to develop applications using libTorrent.

%package -n python3-module-%upname
Summary: libTorrent python bindings
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-%upname
The python3-module-libtorrent-rasterbar contains
python-3 bindings to libTorrent.

%prep
%setup
%autopatch -p1

%build
%ifarch %mips32
export LIBS=-latomic
%endif

%cmake \
	-DCMAKE_CXX_STANDARD=14 \
	-Dbuild_examples=ON \
	-Dbuild_tests=ON \
	-Dbuild_tools=ON \
	-Dpython-bindings=ON \
	-Dpython-egg-info=ON \
	-Dpython-install-system-dir=ON \
	-DPYTHON_EXECUTABLE:FILEPATH=%_bindir/python3 \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%doc AUTHORS ChangeLog NEWS README.rst
%doc COPYING LICENSE
%_libdir/*.so.%{soname}
%_libdir/*.so.%{soname}.*

%files devel
%_includedir/*
%_libdir/*.so
%_datadir/cmake/Modules/*.cmake
%_libdir/cmake/*

%files -n python3-module-%upname
%python3_sitelibdir/libtorrent*.so
%python3_sitelibdir/*.egg-info

%changelog
