Group: Development/Other
%add_optflags %optflags_shared
%define oldname varconf
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libvarconf
Version:        1.0.1
Release:        alt2_16
Summary:        Configuration library used by WorldForge clients

License:        LGPLv2+
URL:            http://worldforge.org/dev/eng/libraries/varconf
Source0:        http://downloads.sourceforge.net/worldforge/%{oldname}-%{version}.tar.bz2

BuildRequires:  gcc-c++
BuildRequires:  libsigc++2-devel
Source44: import.info
Provides: varconf = %{version}-%{release}

%description
Varconf is a configuration library intended for all applications. It manages
configuration data in files, command line arguments, and is used by most
WorldForge components.


%package devel
Group: Development/Other
Summary: Development files for varconf library
Requires: pkgconfig %{oldname} = %{version}-%{release}
Provides: varconf-devel = %{version}-%{release}


%description devel
Development libraries and headers for linking against the varconf library.


%prep
%setup -n %{oldname}-%{version} -q



%build
%add_optflags -std=c++14
%configure
%make_build


%install
%makeinstall_std

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

## cleaning up redundant docs
rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/%{oldname}-%{version}

%check
make %{?_smp_mflags} check
cd tests ; ./conftest < conf.cfg




%files
%doc AUTHORS ChangeLog README THANKS TODO
%doc --no-dereference COPYING
%{_libdir}/lib%{oldname}-1.0.so.*


%files devel
%{_includedir}/%{oldname}-1.0
%{_libdir}/lib%{oldname}-1.0.so
%{_libdir}/pkgconfig/*.pc


%changelog
