%define soname 8
%ifarch %ix86
%define platform x86-linux-gcc
%else
%ifarch arm
%define platform armv5te-linux-gcc
%else
%ifarch armh
%define platform armv7-linux-gcc
%else
%ifarch %e2k
%define platform generic-gnu
%else
%ifarch aarch64
%define platform arm64-linux-gcc
%else
%define platform %_arch-linux-gcc
%endif
%endif
%endif
%endif
%endif

Name: libvpx%soname
Version: 1.13.1
Release: alt3
Summary: VP8 video codec
Group: Video
License: BSD
Url: http://www.webmproject.org/

Source0: %name-%version.tar
Patch: %name-%version-%release.patch
Obsoletes: libvpx6 >= 1.13
Conflicts: libvpx6 >= 1.13

BuildRequires: doxygen gcc-c++
%ifarch %ix86 x86_64
BuildRequires: yasm
%endif

%description
VP8 is an open video codec, originally developed by On2 and released
as open source by Google Inc. It is the successor of the VP3 codec,
on which the Theora codec was based

%prep
%setup
%patch -p1
%ifarch armh
sed -i -e 's,softfp,hard,' build/make/configure.sh
%endif

%build
%ifarch %ix86 x86_64 %arm
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%endif
./configure \
	--prefix=%prefix \
	--libdir=%_libdir \
	--enable-pic \
	--target=%platform \
	--enable-shared \
	%ifnarch x86_64
	--disable-avx \
	--disable-avx2 \
	%endif
	--disable-install-srcs \
	--enable-vp9-decoder \
	--enable-vp9-encoder \
	--enable-experimental \
	--enable-vp9-highbitdepth \
	--disable-static
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS LICENSE PATENTS CHANGELOG
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%changelog
