# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%add_optflags %optflags_shared
%define oldname wfmath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libwfmath
Version:        1.0.2
Release:        alt1_11
Summary:        WorldForge client math libraries

Group:          Development/Other
License:        GPLv2+
URL:            http://worldforge.org/dev/eng/libraries/wfmath
Source0:        http://downloads.sourceforge.net/sourceforge/worldforge/%{oldname}-%{version}.tar.bz2

BuildRequires:  doxygen
# Testing needs
BuildRequires:  libatlascpp-devel
Source44: import.info
Provides: wfmath = %{version}-%{release}

%description
WFMath provides mathematical functions for WorldForge clients.  The primary
focus of WFMath is geometric objects. Thus, it includes several shapes (boxes,
balls, lines), in addition to the basic math objects that are used to build
these shapes (points, vectors, matrices). WFMath provides a means for other
system compenents to pass geometric information around in a common format.


%package        devel
Summary:        Development files for wfmath
Group:          Development/Other
Requires:       pkg-config %{oldname} = %{version}-%{release}
Provides: wfmath-devel = %{version}-%{release}


%description    devel
Libraries and header files for developing applications that use wfmath.


%prep
%setup -n %{oldname}-%{version} -q


%build
# tests fail when build with -O2 on these arches
%ifarch s390 s390x
CXXFLAGS="%{optflags} -O0" \
%endif
%configure --disable-static
%make_build

make docs
# Rename a messed-up man page
mv doc/man/man3/WFMath_Polygon_* doc/man/man3/WFMath_Polygon_2.3
# Delete a messed-up man page that sometimes appears
rm -f doc/man/man3/*_.3

# Remove timestamps from the generated documentation to avoid
# multiarch conflicts

for file in doc/html/*.html ; do
    sed -i -e 's/Generated on .* for WFMath by/Generated for WFMath by/' $file
done

%install
make install DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man3/
install -p -m0644 doc/man/man3/*.3 $RPM_BUILD_ROOT%{_mandir}/man3/

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la


%check
# Run tests in debug mode so asserts won't be skipped
sed -i -e 's/-DNDEBUG/-DDEBUG/' wfmath/Makefile
make %{?_smp_mflags} check

%files
%doc AUTHORS COPYING README TODO ChangeLog
%{_libdir}/lib%{oldname}-1.0.so.*


%files devel
%doc doc/CLASS_LAYOUT doc/html/
%{_includedir}/%{oldname}-1.0
%{_libdir}/lib%{oldname}-1.0.so
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man3/**


%changelog
