Name: libxslt
Version: 1.1.43
Release: alt1

Summary: Library providing XSLT support
License: MIT
Group: System/Libraries
Url: http://xmlsoft.org/

%def_disable static
%def_without python
%def_without crypto
%define srcname %name-%version

# git://git.gnome.org/libxslt.git
Source: %srcname.tar
# git://git.altlinux.org/gears/l/libxslt.git
Patch: %name-%version-%release.patch

BuildRequires: libxml2-devel
%if_with crypto
BuildRequires: libgcrypt-devel
%endif

%package -n xsltproc
Summary: XSLT processor using libxslt
Group: Text tools
Requires: %name = %version-%release

%package devel
Summary: Development environment for XSLT
Group: Development/C
Requires: %name = %version-%release

%package devel-doc
Summary: Development documentation for XSLT
Group: Development/C
BuildArch: noarch

%package devel-static
Summary: Static library for XSLT
Group: Development/C
Requires: %name-devel = %version-%release

%if_with python
%setup_python_subpackage %name
%package -n %packagename
Summary: Python bindings for the %name library
Group: Development/Python
BuildRequires: python-module-libxml2
%setup_std_python_package_deps
Requires: %name = %version-%release
Requires: python-module-libxml2
Provides: python-modules-%name = %version-%release
Provides: libxslt-python = %version-%release
Obsoletes: python-modules-%name < %version-%release
Obsoletes: libxslt-python < %version-%release

%description -n python-module-%name
This package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libxslt library to apply XSLT transformations.

This library allows to parse sytlesheets, uses the %name-python
to load and save XML and HTML files. Direct access to XPath and
the XSLT transformation context are possible to extend the XSLT language
with XPath functions written in Python.
%endif

%description
XSLT library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism.

This package provides shared library required for run XSLT-based software.

%description -n xsltproc
This package provides an XSLT processor based on the libxslt C library.
It allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism.

%description devel
XSLT library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism.

This package provides include files required for software development
with XSLT.

%description devel-doc
XSLT library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism.

This package provides documentation on software development
with the XSLT library.

%description devel-static
XSLT library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism.

This package provides static library required for development of
statically linked programs with XSLT.

%prep
%setup -n %srcname
%patch -p1

%build
export ac_cv_path_XMLLINT=/usr/bin/xmllint
export ac_cv_path_XSLTPROC=/usr/bin/xsltproc
# disable dependency on binutils-devel
export ac_cv_header_ansidecl_h=no
%define pkgdocdir %_docdir/%name-%version
%autoreconf
%configure \
	--docdir=%pkgdocdir \
	%{subst_with python} \
	%{subst_with crypto} \
	%{subst_enable static}

%make_build

%install
%makeinstall_std
# Replace libexslt.so symlink with a linker script.
rm %buildroot%_libdir/libexslt.so
cat > %buildroot%_libdir/libexslt.so << '__EOF__'
/* GNU ld script */
GROUP(libexslt.so.0 AS_NEEDED(-lxslt))
__EOF__
install -pm644 AUTHORS Copyright FEATURES NEWS README.md %buildroot%pkgdocdir/

%check
make check

%files
%_libdir/*.so.*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/Copyright
%pkgdocdir/FEATURES
%pkgdocdir/NEWS
%pkgdocdir/README.md

%files -n xsltproc
%_bindir/xsltproc
%_man1dir/xsltproc.1*

%files devel
%_bindir/*-config
%_libdir/*.so
%_libdir/*.sh
%_includedir/*
%_libdir/cmake/libxslt
%_libdir/pkgconfig/*

%files devel-doc
%_man3dir/*
%dir %pkgdocdir
%pkgdocdir/*.html
#pkgdocdir/*.gif
%pkgdocdir/html
%pkgdocdir/tutorial*
#pkgdocdir/EXSLT

%if_enabled static
%files devel-static
%_libdir/*.a
%endif # enabled static

%if_with python
%files -n python-module-%name
%python_sitelibdir/*
%dir %pkgdocdir
%dir %pkgdocdir/python
%dir %pkgdocdir/python/examples
%pkgdocdir/python/examples/*.py
%pkgdocdir/python/examples/*.xml
%pkgdocdir/python/examples/*.xsl
%endif # enabled python

%changelog
