%def_disable snapshot

%def_disable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}
%def_disable java
# don't use aspell as Abiword uses hanspell via libenchant
%def_disable aspell
%def_enable hunspell
%def_disable perl
%def_disable system_minisat

%define dictdir %_datadir/myspell

Name: link-grammar
Version: 5.12.4
Release: alt1

Summary: The link grammar parsing system for Unix
License: BSD-3-Clause and LGPL-2.1
Group: Text tools
Url: https://github.com/opencog/link-grammar

%if_disabled snapshot
#Source: http://www.abisource.com/downloads/%name/%version/%name-%version.tar.gz
Source: %url/archive/%name-%version.tar.gz
%else
Vcs: https://github.com/opencog/link-grammar.git
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release

BuildRequires: gcc-c++ autoconf-archive swig flex
BuildRequires: libedit-devel libsqlite3-devel zlib-devel
BuildRequires: libpcre2-devel
%{?_enable_aspell:BuildRequires:libaspell-devel}
%{?_enable_hunspell:BuildRequires:libhunspell-devel}
%{?_enable_perl:BuildRequires: perl-devel}
%{?_enable_system_minisat:BuildRequires:libminisat-devel}

%description
The link grammar parsing system for Unix.

%package -n lib%name
Summary: Library files for %name
Group: System/Libraries

%description -n lib%name
Library files for %name

%package -n lib%name-devel
Summary: Development files needed to build applications with %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files needed to build applications with %name.

%package -n perl-%name
Summary: Perl bindings for %name
Group: Development/Perl
Requires: lib%name = %version-%release

%description -n perl-%name
Perl bindings for %name library.

%prep
%setup %{?_disable_snapshot:-n %name-%name-%version}

%build
%autoreconf
%add_optflags %(getconf LFS_CFLAGS)
%configure \
	%{subst_enable static} \
	--with-hunspell-dictdir=%dictdir \
	%{?_disable_java:--disable-java-bindings} \
	%{subst_enable aspell} \
	%{subst_enable hunspell} \
	%{?_disable_system_minisat:--enable-sat-solver=bundled}
%nil
%make_build

%install
%makeinstall_std

%files
%_bindir/link-parser
%_bindir/link-generator
%_man1dir/link-parser.1*
%_man1dir/link-generator.1*
%doc LICENSE README* ChangeLog

%files -n lib%name
%dir %_datadir/%name/
%_datadir/%name/*
%_libdir/*.so.*

%files -n lib%name-devel
%dir %_includedir/%name/
%_includedir/%name/*
%_libdir/*.so
%_pkgconfigdir/%name.pc
#%exclude %_libdir/*.a

%if_enabled perl
%files -n perl-%name
%perl_vendor_privlib/*
%endif

%changelog
