# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%set_verify_elf_method unresolved=relaxed
Name: linuxcnc
Version: 2.9.7
Release: alt1

Summary: LinuxCNC controls CNC machines
Summary(ru_RU.UTF-8): Программное обеспечение для управления станками c ЧПУ
License: GPL-2.0-or-later and LGPL-2.0-or-later
Group: Engineering
Url: https://github.com/LinuxCNC/linuxcnc

ExclusiveArch: aarch64 alpha %arm ia64 %ix86 x86_64 %e2k loongarch64

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-tcl rpm-build-python3 rpm-macros-qt5-webengine
BuildRequires: rpm-build-gir
BuildRequires: python3-devel
BuildRequires: gcc-c++ pkgconfig(glib-2.0)
BuildRequires: libgtk+3-gir-devel
BuildRequires: libgtk+2-devel
BuildRequires: python3-module-pygobject3
BuildRequires: libGL-devel libGLU-devel
BuildRequires: libXaw-devel libXinerama-devel libXmu-devel libXt-devel xorg-cf-files
BuildRequires: libepoxy-devel
BuildRequires: pkgconfig(libmodbus)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(libudev)
BuildRequires: libncurses-devel libreadline-devel
BuildRequires: libtirpc-devel
BuildRequires: kmod
BuildRequires: man-db
BuildRequires: python3-modules-tkinter
#python3-modules-unittest
BuildRequires: python3-module-yapps2
BuildRequires: boost-devel-headers
BuildRequires: boost-lockfree-devel
BuildRequires: boost-python3-devel
BuildRequires: tcl-devel tk-devel tcl-img tclx bwidget
#BuildRequires: tcl-blt-devel
BuildRequires: intltool
#BuildRequires: pkgconfig(libgnomeprintui-2.2)
BuildRequires: desktop-file-utils ImageMagick-tools
BuildRequires: asciidoc-a2x
BuildRequires: dos2unix
# for build with tk
BuildRequires: libXScrnSaver-devel

Obsoletes: %name-data =< %EVR
Requires: lib%name = %EVR

# for Axis
Requires: libGLU

# for qtvcp
Requires: python3-module-PyQt5-devel

# for gmoccapy
Requires: libgtksourceview4-gir
Requires: libX11-devel

# for qtplasma
%ifarch %qt5_qtwebengine_arches
%py3_requires PyQt5.QtWebEngineWidgets
%endif
%py3_requires cv2

Requires: tclx tcl-blt
%py3_requires Xlib
%py3_requires PyQt5.Qsci

# https://bugzilla.altlinux.org/52950
Requires: python3-module-pygobject3

# Fix me!!!
%add_python3_req_skip __main__ gi.repository.GdkPixbuf gst gtk glib gtk.glade Cairo
%add_python3_req_skip emccanon interpreter
%add_python3_req_skip plasmac qtvcp.lib.qt_pdf

%filter_from_requires s/^.*rip-environment//
%filter_from_requires s/^.*typelib(Cairo)//
%filter_from_requires s/^sudo$//

%add_python3_path %_datadir/qtvcp
%add_python3_path %_datadir/%name/ncfiles

%description
LinuxCNC is software that runs on Linux, on most standard PCs, that can
interpret G-code and run a CNC machine. It was originally developed on a
milling machine, but support was added for lathes and many other types of
machine. It can be used with mills, lathes, plasma cutters, routers, robots,
and so on.

%description -l ru_RU.UTF-8
LinuxCNC это программа, которая работает на ОС Linux на большинстве стандартных
ПК, которые могут интерпретировать G-код и запустить станок с ЧПУ. Изначально он
был разработан для фрезерного станка, но поддержка была добавлена и для токарных
станков и многих других типов машин. Он может быть использован с токарными
станками, станками плазменной резки, роботами и так далее.

%package -n liblinuxcnc-devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description -n liblinuxcnc-devel
Development files for %name

%package -n lib%name
Summary: Library for %name
Group: Engineering

%description -n lib%name
Library for %name

%package doc
Summary: Documementation for %name
BuildArch: noarch
Group: Documentation

%description doc
Documementation for %name

%package doc-fr
Summary: French documementation for %name
BuildArch: noarch
Group: Documentation
Requires: %name-doc = %version

%description doc-fr
French documementation for %name

%package doc-es
Summary: Spanish documementation for %name
BuildArch: noarch
Group: Documentation
Requires: %name-doc = %version

%description doc-es
Spanish documementation for %name

%prep
%setup
%patch -p1

sed -i 's|lib/tcltk/linuxcnc|%_lib/tcl/linuxcnc|' lib/python/rs274/options.py
sed -i 's|INCLUDES := .|INCLUDES := . /usr/include/tirpc|' src/Makefile
sed -i 's|LDFLAGS := |LDFLAGS := -ltirpc |' src/Makefile

#fix make install
sed 's/ -o root//g' -i src/Makefile

%ifarch %e2k
# unsupported as of lcc 1.25.17
sed -i 's,-fno-fast-math,,' src/Makefile*
# need for correct detection of boost libs path
sed -i 's,sparc64|,&e2k|,' src/m4/ax_boost_base.m4
%endif

find . -name '*.py' -exec dos2unix "{}" \;

# fix unavailable GROUP "plugdev"
sed -i 's/GROUP="plugdev"/GROUP="uucp"/g' debian/extras/lib/udev/rules.d/*

%build
pushd src
./autogen.sh
%configure \
    --enable-non-distributable=yes \
    --with-realtime=uspace

%make_build
popd

%install
pushd src
%makeinstall_std SITEPY=%python3_sitelibdir
popd

# install rules
mkdir -p %buildroot%_udevrulesdir
cp debian/extras/lib/udev/rules.d/* %buildroot%_udevrulesdir

# fix desktop categories
desktop-file-install --dir %buildroot%_desktopdir \
        --remove-key=Version \
        --remove-category=X-CNC \
        --remove-category=Utility \
        %buildroot%_desktopdir/*.desktop

### == desktop file documentation
cat>%buildroot%_desktopdir/%name-documentation.desktop<<END
[Desktop Entry]
Name=LinuxCNC Documentation
Name[ru_RU]=LinuxCNC Документация
Exec=%_bindir/xdg-open %_docdir/%name
Icon=linuxcncicon
Terminal=false
Type=Application
Categories=Science;Engineering;
END

# convert and install icon files
for x in 16 32 48; do
    mkdir -p %buildroot%_iconsdir/hicolor/$x'x'$x/apps
    convert linuxcncicon.png -resize $x'x'$x \
            %buildroot%_iconsdir/hicolor/$x'x'$x/apps/linuxcncicon.png
done

# fix uncompressed manual pages
pushd %buildroot%_mandir
xz `find -name *.?`
popd

# remove unpackaged static libraries
rm %buildroot%_libdir/*.a

%find_lang %name gmoccapy --output=%name.lang

%files -f %name.lang
%_bindir/*
%_libexecdir/%name
%_libdir/%name
%_tcllibdir/%name
%python3_sitelibdir/*
%_sysconfdir/%name
%_udevrulesdir/*.rules
%_desktopdir/*.desktop
%_sysconfdir/X11/app-defaults/*
%_datadir/axis
%_datadir/%name
%_datadir/glade
%_datadir/gmoccapy
%_datadir/gscreen
%_datadir/gtksourceview-4/*
%_datadir/qtvcp
%_liconsdir/*
%_niconsdir/*
%_miconsdir/*
%_mandir/man?/*
%_docdir/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/%name
%_libdir/*.so

%changelog
