Name: logrotate
Version: 3.20.1
Release: alt2

Summary: Rotates, compresses, and mails system logs
License: GPL-2.0-or-later
Group: File tools
Url: https://github.com/logrotate/logrotate

# https://github.com/logrotate/logrotate/releases/download/%version/logrotate-%version.tar.xz
Source: logrotate-%version.tar
Source1: logrotate.cron

Patch1: 0001-ALT-Improve-messages-about-wrong-file-types.patch
Patch2: 0002-ALT-Change-logrotate-defaults.patch
Patch3: 0003-ALT-insecure-permissions.patch
Patch4: 0004-ALT-Add-more-taboo-suffixes.patch

Provides: /etc/logrotate.d

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%set_verify_elf_method strict

%def_with selinux

BuildRequires: libacl-devel libpopt-devel
%{?_with_selinux:BuildPreReq: libselinux-devel}

%description
The logrotate utility is designed to simplify the administration of log
files on a system which generates a lot of log files.  logrotate allows
for the automatic rotation, compression, removal and mailing of log files.
logrotate can be set to handle a log file daily, weekly, monthly or
when the log file gets to a certain size.  Normally, logrotate runs as
a daily cron job.

%prep
%setup
%autopatch -p1

%build
touch AUTHORS ChangeLog NEWS README
%autoreconf
%configure %{subst_with selinux}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot{/etc/logrotate.d,%_unitdir}

install -pD -m640 examples/logrotate.conf %buildroot/etc/logrotate.conf
install -pD -m640 examples/btmp %buildroot/etc/logrotate.d/btmp
install -pD -m640 examples/wtmp %buildroot/etc/logrotate.d/wtmp
install -pD -m755 %_sourcedir/logrotate.cron %buildroot/etc/cron.daily/logrotate
install -pD -m644 /dev/null %buildroot%_localstatedir/logrotate/status
install -pD -m644 examples/logrotate.{service,timer} %buildroot%_unitdir/

%check
make test

%post
if [ ! -s %_localstatedir/logrotate/status -a -s %_localstatedir/logrotate.status ]; then
	mv -f %_localstatedir/logrotate.status %_localstatedir/logrotate/status
fi
if sd_booted; then
%post_service logrotate.timer
fi

%preun
if sd_booted; then
%preun_service logrotate.timer
fi

%files
%_sbindir/*
%config(noreplace) /etc/cron.daily/logrotate
%config(noreplace) /etc/logrotate.conf
%config(noreplace) /etc/logrotate.d/btmp
%config(noreplace) /etc/logrotate.d/wtmp
%_mandir/man?/*
%attr(750,root,root) %dir /etc/logrotate.d
%attr(700,root,root) %dir %_localstatedir/logrotate
%attr(644,root,root) %verify(not size md5 mtime) %config(noreplace) %_localstatedir/logrotate/status
%_unitdir/logrotate.*
%doc ChangeLog.md

%changelog
