Name: m4
Version: 1.4.19.0.15.bb35
Release: alt1

Summary: The GNU macro processor
License: GPLv3+
Group: Development/Other
Url: https://www.gnu.org/software/m4/

# git://git.altlinux.org/gears/m/m4.git
Source: %name-%version-%release.tar

BuildRequires: gnulib >= 0.1.4645.3639c
BuildRequires: gperf
BuildRequires: help2man
BuildRequires: makeinfo

%description
A GNU implementation of the traditional UNIX macro processor.  m4 is
useful for writing text files which can be logically parsed, and is
used by many programs as part of their build process.  m4 has built-in
functions for including files, running shell commands, doing arithmetic,
etc.  The autoconf program needs m4 for generating configure scripts,
but not for running configure scripts.

%prep
%setup -n %name-%version-%release

# Build scripts expect to find m4 version in this file.
echo -n %version > .tarball-version

rmdir gnulib
ln -s %_datadir/gnulib .

%build
./bootstrap --skip-po --force
%configure
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
install -pD -m644 m4/m4.m4 %buildroot%_aclocaldir/m4.m4

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
%make_build -k check VERBOSE=1

%files
%_bindir/*
%_infodir/*.info*
%_man1dir/*
%_aclocaldir/*
%doc AUTHORS BACKLOG NEWS README THANKS TODO

%changelog
