Name: matrix-synapse
Version: 1.129.0
Release: alt1

Summary: Synapse: Matrix reference homeserver
License: Apache-2.0
Group: Communications

Url: http://matrix.org

# Source-url: https://github.com/element-hq/synapse/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

# Cargo modules for build rust code in the rust dir
Source1: %name-development-%version.tar

Source10: %name.service



BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3

BuildRequires: python3 >= 3.8

%py3_buildrequires setuptools_rust >= 1.3
%py3_buildrequires poetry

%py3_use matrix-angular-sdk >= 0.6.8

# generated by 'epm restore --dry-run' from matrix-synapse/pyproject.toml
%py3_use jsonschema >= 3.0.0
%py3_use immutabledict >= 2.0
%py3_use unpaddedbase64 >= 2.1.0
%py3_use canonicaljson >= 2.0.0
%py3_use signedjson >= 1.1.0
%py3_use service-identity >= 18.1.0
%py3_use twisted-core >= 18.9.0
%py3_use treq >= 15.1
%py3_use OpenSSL >= 16.0.0
%py3_use yaml >= 5.3
%py3_use pyasn1 >= 0.1.9
%py3_use pyasn1-modules >= 0.0.7
%py3_use bcrypt >= 3.1.7
%py3_use Pillow >= 10.0.1
%py3_use sortedcontainers >= 1.5.2
%py3_use pymacaroons >= 0.13.0
%py3_use msgpack >= 0.5.2
%py3_use phonenumbers >= 8.2.0
%py3_use prometheus-client >= 0.4.0
%py3_use attrs >= 19.2.0
%py3_use attrs >= 21.1.0
%py3_use netaddr >= 0.7.18
%py3_use jinja2 >= 3.0
%py3_use bleach >= 1.4.3
%py3_use typing-extensions >= 4.1
%py3_use cryptography >= 3.4.7
%py3_use ijson >= 3.1.4
%py3_use matrix-common >= 1.3.0
%py3_use packaging >= 20.0
%py3_use pydantic < 3
%py3_use pydantic >= 1.7.4
# python-multipart, not just multipart
%py3_use python-multipart >= 0.0.9

# optional
#py3_use matrix-synapse-ldap3 >= 0.1
%py3_use psycopg2 >= 2.8
%py3_use psycopg2cffi >= 2.8
#py3_use psycopg2cffi-compat >= 1.1

%py3_use systemd >= 231
%py3_use lxml >= 4.5.2

# optional auth
%py3_use pysaml2 >= 4.5.0
%py3_use authlib >= 0.15.1

# optional
#py3_use sentry-sdk >= 0.7.2
#py3_use opentracing >= 2.2.0
#py3_use jaeger-client >= 4.0.0

%py3_use txredisapi >= 1.4.7
#py3_use hiredis-py  
%py3_use pympler
%py3_use idna >= 2.5

%py3_use icu >= 2.10.2

# "test"
#py3_use parameterized >= 0.7.4
#py3_use mock >= 2.0

BuildRequires: rust-cargo

# for /usr/lib/matrix-synapse/sync_room_to_group.pl
BuildRequires: perl-CPAN
BuildRequires: perl-JSON-XS

Requires: python3-module-twisted-conch >= 17.5.0
Requires: python3-module-twisted-names >= 17.5.0
Requires: python3-module-twisted-web >= 17.5.0
Requires: python3-module-twisted-mail >= 17.5.0

# python-modules-sqlite3
#Requires: python-module-matrix-angular-sdk

# optional
%add_python3_req_skip opentracing
# internal (not provides from rust module)
%add_python3_req_skip synapse.synapse_rust.push synapse.synapse_rust.acl synapse.synapse_rust.events synapse.synapse_rust.rendezvous

%description
Matrix is an ambitious new ecosystem for open federated Instant Messaging and VoIP.

Synapse is the reference python/twisted Matrix homeserver implementation.

%prep
%setup -a1
mkdir -p .cargo
cat <<EOF >> .cargo/config
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"
EOF

%build
%pyproject_build

%install
%pyproject_install
# --install-scripts=%_libexecdir/%name/
mkdir -p %buildroot/etc/synapse
cp contrib/systemd/log_config.yaml %buildroot/etc/synapse/
# TODO
echo >%buildroot/etc/synapse/homeserver.yaml
install -m644 -D %SOURCE10 %buildroot%_unitdir/matrix-synapse.service
mkdir -p %buildroot/var/{run,lib,log}/synapse
mkdir -p %buildroot%_tmpfilesdir/
echo "D /var/run/synapse 0710 _synapse _synapse -" >%buildroot%_tmpfilesdir/%name.conf

# remove benchmark test
rm -rfv %buildroot%python3_sitelibdir_noarch/synmark/

%pre
/usr/sbin/groupadd -r -f _synapse
/usr/sbin/useradd -r -g _synapse -d /var/lib/synapse -s /dev/null -c 'Synapse user' _synapse >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
        /usr/sbin/usermod -d /var/lib/synapse _synapse
fi

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.rst UPGRADE.rst CHANGES.md AUTHORS.rst docs/
%_bindir/export_signing_key
%_bindir/generate_config
%_bindir/generate_log_config
%_bindir/generate_signing_key
%_bindir/hash_password
%_bindir/register_new_matrix_user
%_bindir/synapse_homeserver
%_bindir/synapse_port_db
%_bindir/synapse_review_recent_signups
%_bindir/synapse_worker
%_bindir/synctl
%_bindir/update_synapse_database
%_unitdir/matrix-synapse.service
%_tmpfilesdir/%name.conf
%python3_sitelibdir/*
%dir /etc/synapse/
%attr(0640,root,_synapse) %config(noreplace) /etc/synapse/homeserver.yaml
%attr(0640,root,_synapse) %config(noreplace) /etc/synapse/log_config.yaml

%attr(0710,_synapse,_synapse) /var/run/synapse/
%attr(0710,_synapse,_synapse) /var/lib/synapse/
%attr(0750,_synapse,_synapse) /var/log/synapse/

%changelog
