%define _unpackaged_files_terminate_build 1
%define _localstatedir %{_var}

Name: mbrola
Version: 3.3
Release: alt4

Summary: MBROLA is a speech synthesizer based on the concatenation of diphones
License: AGPL-3.0
Group:   Sound
Url:     https://github.com/numediart/MBROLA

Source: %name-%version.tar

Requires:       sox-base
Requires: freespeech

BuildRequires: gcc
BuildRequires: make
BuildRequires: fdupes

%description
MBROLA is a speech synthesizer based on the concatenation of diphones.
It takes a list of phonemes as input, together with prosodic information
(duration of phonemes  and a piecewise linear description of pitch),
and produces speech samples on 16 bits (linear), at the sampling
frequency of the diphone database.

It is therefore NOT a Text-To-Speech  (TTS) synthesizer, since it does
not accept raw text as input.  In  order to obtain  a full TTS system,
you need to use this synthesizer in combination with a text processing
system that produces phonetic and prosodic commands such as festival
or freespeech.

%prep
%setup
sed -i 's/SYNTH_VERSION.*/SYNTH_VERSION \"%version\"/' Misc/common.h
%ifarch %e2k
# e2k: fix optlevel (lcc won't accept insane values)
sed -i 's,-O6,-O%_optlevel,g' Makefile
%endif

%build
export CFLAGS="%optflags"
%make_build -j1

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_datadir/mbrola
install -m 755 ./Bin/mbrola %buildroot%_bindir/mbrola
fdupes %buildroot%_datadir/%name

%files
%doc README.md
%doc --no-dereference LICENSE
%_bindir/mbrola
%_datadir/%name

%changelog
