Name: menulibre
Version: 2.2.3
Release: alt1

Summary: Advanced FreeDesktop.org compliant menu editor
License: GPL-3.0-only
Group: Graphical desktop/Other
BuildArch: noarch
Epoch: 1

URL: https://github.com/bluesabre/menulibre
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): intltool
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-distutils-extra
BuildRequires: python3-module-pyxdg python3-module-pygobject3 libgtk+3-gir-devel libgtksourceview3-gir-devel libgnome-menus-gir-devel

Requires: libgtk+3-gir libgtksourceview3-gir libgnome-menus-gir

%define _unpackaged_files_terminate_build 1

%description
MenuLibre is an advanced menu editor that provides modern features in a clean,
easy-to-use interface.
All fields specified in the FreeDesktop.org Desktop Entry and Menu
specifications are available to quickly update. Additionally, MenuLibre provides
an editor for the launcher actions used by applications such as Unity and Plank.

Features:
  * A beautiful interface powered by the latest version of GTK+;
  * Create new launchers, or modify existing ones with complete control over
    common settings and access to advanced settings;
  * Add, remove, and adjust desktop actions: powerful shortcuts available used
    by Unity, Xfce, and Pantheon;
  * Easily rearrange menu items to suit your needs.

%prep
%setup
%patch0 -p1

%build
export XDG_RUNTIME_DIR="$TMPDIR"
%python3_build

%install
install -Dm0644 build/share/applications/menulibre.desktop %buildroot%_desktopdir/%name.desktop
export LANG=C.UTF-8
export XDG_RUNTIME_DIR="$TMPDIR"
%python3_install

# Install localizations
mkdir -p %buildroot%_datadir/locale
cp -a build/mo/* %buildroot%_datadir/locale/

%find_lang %name

%files -f %name.lang
%doc %_defaultdocdir/%name
%_bindir/%{name}*
%_datadir/%name/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*.*
%_pixmapsdir/*.*
%_man1dir/%{name}*.*
%_datadir/metainfo/*.xml
%python3_sitelibdir_noarch/%{name}*

# Glibc doesn't support ms@Arab locale
%exclude %_datadir/locale/ms@Arab/LC_MESSAGES/menulibre.mo

%changelog
