%define set_disable() %{expand:%%force_disable %1} %{expand:%%undefine _enable_%1}
%define set_enable() %{expand:%%force_enable %1} %{expand:%%undefine _disable_%1}
%define mIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define mIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define mIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define mIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%def_disable debug
%def_enable libvidstab
%def_enable opencv

%define Name MLT
%define nam mlt
%define mlt_major 7
%define mlt_sover 7
%define libmlt libmlt%mlt_sover
%define mltxx_sover 7
%define libmltxx libmlt++%mltxx_sover

Name: %nam%mlt_major
Version: 7.34.1
Release: alt2
%K5init no_altplace

Summary: Multimedia framework designed for television broadcasting
License: GPL-3.0-or-later
Group: Video
Url: https://www.mltframework.org/

Source: %nam-%version.tar
Source1: mlt++-config.h
Source10: glaxnimate.tar
# ALT
Patch102: alt-no-version-script.patch
Patch103: alt-ix86.patch

BuildRequires(pre): rpm-build-kf5 rpm-build-python3 libavformat-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt6-svg-devel qt6-5compat-devel
BuildRequires: cmake
BuildRequires: libvulkan-devel
BuildRequires: frei0r-devel libSDL-devel libSDL2-devel libSDL2_image-devel libalsa-devel libexif-devel
BuildRequires: libavfilter-devel libswscale-devel libavdevice-devel libavformat-devel libswresample-devel
BuildRequires: libfftw3-devel libjack-devel libpulseaudio-devel libsamplerate-devel libsox-devel
BuildRequires: librubberband-devel libvorbis-devel
BuildRequires: libxml2-devel swig ladspa_sdk liblilv-devel
BuildRequires: libarchive-devel
%if_enabled libvidstab
BuildRequires: libvidstab-devel
%endif
%if_enabled opencv
BuildRequires: libopencv-devel
%endif
BuildRequires: movit-devel
BuildRequires: python3-devel
BuildRequires: libgdk-pixbuf-devel libpango-devel

%description
%Name is a multimedia framework designed for television broadcasting.

%package -n %nam-utils
Summary: %Name utils
Group: Video
%description -n %nam-utils
%Name utils.

%package -n %nam-qt5
Summary: %Name Qt plugins
Group: Video
Conflicts: libmlt7 < 7.34.1
%description -n %nam-qt5
%Name Qt plugins.

%package -n %nam-qt6
Summary: %Name Qt plugins
Group: Video
Conflicts: libmlt7 < 7.34.1
%description -n %nam-qt6
%Name Qt plugins.

%package -n %libmlt
Summary: %Name framework library
Group: System/Libraries
Requires: %nam-qt6 >= %version
%description -n %libmlt
%Name is a multimedia framework designed for television broadcasting.

%package -n %libmltxx
Summary: C++ wrapping for the MLT library
Group: System/Libraries
%description -n %libmltxx
This mlt sub-project provides a C++ wrapping for the MLT library.

%package -n %name-devel
Summary: Development files for %Name framework
Group: Development/C
%description -n %name-devel
Development files for %Name framework.

%package -n %{name}xx-devel
Summary: Development files for %Name
Group: Development/C++
Requires: %name-devel
%description -n %{name}xx-devel
Development files for %Name.

%package -n python3-module-%name
Summary: Python package to work with %Name
Group: Development/Python
%description -n python3-module-%name
This module allows to work with %Name using python..

%prep
%setup -n %nam-%version -a10
%ifarch %e2k
# see glaxnimate 0.5.4-alt2 package
sed -i 's/ch\.unicode()/(ushort)&/' \
	glaxnimate/src/core/io/svg/path_parser.hpp
sed -i "s/push_back('\\\\0')/push_back((QChar)'\\\\0')/" \
	glaxnimate/src/core/io/avd/avd_parser.cpp
%endif
rm -rf src/modules/glaxnimate/glaxnimate
mv glaxnimate src/modules/glaxnimate/
%patch102 -p1
%patch103 -p1

[ -f src/mlt++/config.h ] || \
    install -m 0644 %SOURCE1 src/mlt++/config.h

%build
%mIF_ver_lt %_qt5_version 5.9
%add_optflags -std=c++11
%endif
export CC=gcc CXX=g++ CFLAGS="%optflags" QTDIR=%_qt5_prefix
%add_optflags -DAVDATADIR="%_datadir/ffmpeg/"
%K5build \
    -DSWIG_PYTHON=ON \
    -DMOD_OPENCV=%{?_enable_opencv:ON}%{!?_enable_opencv:OFF} \
    -DMOD_QT=ON \
    -DMOD_QT6=ON \
    -DMOD_GLAXNIMATE=ON \
    -DMOD_GLAXNIMATE_QT6=ON \
    #

%install
%make -C BUILD DESTDIR=%buildroot install

%files -n %nam-utils
%_bindir/melt*
%_man1dir/*.1.*

%files -n %libmlt
%_libdir/libmlt-%mlt_major.so.%mlt_sover
%_libdir/libmlt-%mlt_major.so.*
%_libdir/mlt-%mlt_major/
%exclude %_libdir/mlt-%mlt_major/libmltglaxnimate*.so
%exclude %_libdir/mlt-%mlt_major/libmltqt*.so
%_datadir/mlt-%mlt_major/

%files -n %nam-qt5
%_libdir/mlt-%mlt_major/libmltglaxnimate.so
%_libdir/mlt-%mlt_major/libmltqt.so

%files -n %nam-qt6
%_libdir/mlt-%mlt_major/libmltglaxnimate-qt6.so
%_libdir/mlt-%mlt_major/libmltqt6.so

%files -n %libmltxx
%_libdir/libmlt++-%mlt_major.so.%mltxx_sover
%_libdir/libmlt++-%mlt_major.so.*

%files -n python3-module-%name
%python3_sitelibdir/*%{name}*
%python3_sitelibdir/*/*%{name}*

%files -n %name-devel
%dir %_includedir/mlt-%mlt_major/
%_includedir/mlt-%mlt_major/framework/
%_libdir/libmlt-%mlt_major.so
%_libdir/cmake/Mlt7/
%_pkgconfigdir/mlt-framework-%mlt_major.pc

%files -n %{name}xx-devel
%_includedir/mlt-%mlt_major/mlt++/
%_libdir/libmlt++-%mlt_major.so
%_pkgconfigdir/mlt++-%mlt_major.pc

%changelog
