%define _unpackaged_files_terminate_build 1

Name: mos-xdg
Summary: XDG desktop settings for M OS distros
Summary(ru): Настройки рабочего окружения дистрибутивов М ОС
License: GPL-3.0
Group: Graphical desktop/Other
Version: 2.5
Release: alt1
Source0: %name-%version.tar
Source1: COPYING
BuildArch: noarch
BuildRequires: rpm-macros-systemd

%description
XDG desktop settings for M OS distros
%description -l ru_RU.UTF-8
Настройки рабочего окружения дистрибутивов М ОС

#--------------------------------------------------------------

%package core
Summary: Engine to set distribution-specific desktop settings
Summary(ru): Движок установки дистрибутиво-специфичных настроек рабочего стола
Group: Graphical desktop/Other
Requires: sed
# package was renamed
Obsoletes: kometa-xdg-core < 2.0
# this package was dropped as a very complex trick;
# icons are replaced by a filetrigger more reliably
Obsoletes: kometa-xdg-pam-env < 2.0

%description core
Engine to set distribution-specific desktop settings.
Sets environmental variables $XDG_CONFIG_DIRS and $XDG_DATA_DIRS,
adding /etc/xdg/mos and /usr/share/mos into them.
Can be used separately from M OS.
%description -l ru_RU.UTF-8 core
Движок установки дистрибутиво-специфичных настроек рабочего стола.
Устонавливает переменные окружения $XDG_CONFIG_DIRS и $XDG_DATA_DIRS,
добавляя в них /etc/xdg/mos и /usr/share/mos.
Может быть использован вне М ОС.

%files core
%doc COPYING
%dir /etc/xdg/mos
%dir /etc/xdg/mos/autostart
%dir /usr/share/mos
%_bindir/mos-xdg-env
%_user_env_gen_dir/10-mos-xdg.sh
/etc/profile.d/10-mos-xdg.sh

#--------------------------------------------------------------

# alternatives between plasma5-classic, plasma5-foo etc. can be added later

%package plasma5-classic
Summary: KDE 5 desktop settings for classic variant of M OS
Summary(ru): Настройки KDE 5 для классического варианта М ОС
Group: Graphical desktop/KDE
Requires: %name-core = %EVR
Requires: mos-icons-theme-classic
# package was renamed
Obsoletes: kometa-xdg-plasma5-classic < 2.0

%description plasma5-classic
KDE 5 desktop settings for classic variant of M OS
%description -l ru_RU.UTF-8 plasma5-classic
Настройки KDE 5 для классического варианта М ОС

%files plasma5-classic
%doc COPYING
/etc/xdg/mos/dolphinrc
/etc/xdg/mos/kcminputrc
/etc/xdg/mos/kdeglobals
/etc/xdg/mos/kxkbrc
/etc/xdg/mos/mimeapps.list
%dir /usr/share/mos/kxmlgui5
%dir /usr/share/mos/kxmlgui5/dolphin
/usr/share/mos/kxmlgui5/dolphin/dolphinui.rc

#--------------------------------------------------------------

%prep
%setup -q
cp %SOURCE1 .

%build
:

%install

mkdir -p %buildroot%_bindir
mkdir -p %buildroot/etc/profile.d
mkdir -p %buildroot%_user_env_gen_dir
install -m0755 scripts/mos-xdg-env %buildroot%_bindir/mos-xdg-env
# for console
install -m0755 scripts/profile.sh %buildroot/etc/profile.d/10-mos-xdg.sh
# for dbus services
install -m0755 scripts/systemd.sh %buildroot%_user_env_gen_dir/10-mos-xdg.sh

mkdir -p %buildroot/etc/xdg/mos/autostart
cp -rv plasma5/XDG_CONFIG_DIRS/* %buildroot/etc/xdg/mos
mkdir -p %buildroot/usr/share/mos
cp -rv plasma5/XDG_DATA_DIRS/* %buildroot/usr/share/mos

%check
cd scripts
./test.sh

%changelog
