%define mosquitto_user      mosquitto
%define mosquitto_group     mosquitto
%define lname     libmosquitto

Name: mosquitto
Version: 2.0.15
Release: alt1

Summary: Mosquitto is an open source implementation of a server for version 3.1 and 3.1.1 of the MQTT protocol

License: EPL-2.0 and EPL-1.0
Group: Development/C++
Url: http://mosquitto.org

Packager: Pavel Vainerman <pv@altlinux.ru>

# Source-url: http://mosquitto.org/files/source/%name-%version.tar.gz
Source: %name-%version.tar
Source1: %name
Source2: %name.sysconf
Source3: %name.conf

# Automatically added by buildreq on Mon Feb 01 2016
# optimized out: libcom_err-devel libkrb5-devel libstdc++-devel
BuildRequires: gcc-c++ libcares-devel libssl-devel libuuid-devel docbook-style-xsl xsltproc libwebsockets-devel libcjson-devel
Requires: %lname = %version-%release

%set_verify_elf_method unresolved=relaxed

%description
The Mosquitto project has been created to provide a light weight, open-source
implementation, of an MQTT broker to allow new, existing, and emerging
applications for Machine-to-Machine (M2M) and Internet of Things (IoT).

%package -n %lname
Group: Development/C
Summary: Libraries for mosquitto

%description -n %lname
Libraries for mosquitto

%package -n %lname-devel
Group: Development/C
Summary: Libraries needed to develop for mosquitto
Requires: %lname = %version-%release
Obsoletes: %name-devel

%description -n %lname-devel
Libraries needed to develop for mosquitto

%prep
%setup 

subst 's|Invalid memory_limit value (%%ld)|Invalid memory_limit value (%%zd)|g' src/conf.c

%build
subst 's|prefix?=/usr/local|prefix=/usr|g' config.mk
subst 's|stylesheet/docbook-xsl/manpages/docbook.xsl|xsl-stylesheets/manpages/docbook.xsl|g' man/manpage.xsl man/html.xsl
%make_build WITH_WEBSOCKETS=yes

%install
export LIB_SUFFIX='%_libsuff'
%makeinstall_std

chmod a-x %buildroot%_includedir/*.h

mkdir -p %buildroot/%_initdir
cp %SOURCE1 %buildroot%_initdir/

mkdir -p %buildroot/%_sysconfdir/sysconfig
cp %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p %buildroot/%_sysconfdir/%name
cp %SOURCE3 %buildroot%_sysconfdir/%name

install -pDm644 service/systemd/%name.service.simple \
	%buildroot/%_unitdir/%name.service

%pre
%_sbindir/groupadd -r -f %mosquitto_group 2>/dev/null ||:
%_sbindir/useradd -M -r -g %mosquitto_group -c 'Mosquitto daemon' -s /dev/null -d /dev/null %mosquitto_user 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name
        
%files
%dir %_sysconfdir/%name
%config %dir %_sysconfdir/%name/*
%config %_sysconfdir/sysconfig/%name
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man3dir/*
%_man5dir/*
%_man7dir/*
%_man8dir/*
%_initdir/*
%_unitdir/%name.service

%files -n %lname
%_libdir/*.so.*

%files -n %lname-devel
%_includedir/*.h
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%changelog
